/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.editor.tools;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.editor.ICEditorToolType;
import mrtjp.projectred.fabrication.editor.tools.BaseICEditorTool;
import mrtjp.projectred.fabrication.editor.tools.IICEditorTool;
import mrtjp.projectred.fabrication.engine.IRotatableICTile;
import mrtjp.projectred.fabrication.engine.wires.ICWireTileType;
import mrtjp.projectred.fabrication.engine.wires.WireTile;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import mrtjp.projectred.transmission.client.WireModelRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class WirePlacerTool
extends BaseICEditorTool {
    private final Vector3 initialMouseDown = new Vector3();
    private final List<TileCoord> selectedPositionsList = new LinkedList<TileCoord>();
    private final Set<TileCoord> selectedPositionsSet = new HashSet<TileCoord>();
    private boolean leftMouseDown;
    private boolean overwrite = false;
    private ICWireTileType wireType = ICWireTileType.RED_ALLOY;

    public void setWireType(ICWireTileType wireType) {
        this.wireType = wireType;
    }

    public ICWireTileType getWireType() {
        return this.wireType;
    }

    @Override
    public ICEditorToolType getToolType() {
        return ICEditorToolType.WIRE_PLACER_TOOL;
    }

    @Override
    public void readPacket(MCDataInput in) {
        boolean overwrite = in.readBoolean();
        ICWireTileType wireType = ICWireTileType.values()[in.readUByte()];
        int numPositions = in.readUByte();
        byte y = in.readByte();
        for (int i = 0; i < numPositions; ++i) {
            TileCoord pos = new TileCoord(in.readByte(), y, in.readByte());
            if (!this.canPlaceAt(pos, overwrite)) continue;
            WireTile tile = (WireTile)wireType.tileType.create();
            if (this.getEditor().getTileMap().getTile(pos).isPresent()) {
                this.getEditor().removeTile(pos);
            }
            this.getEditor().addTile(tile, pos);
        }
    }

    protected void sendPlaceWires() {
        if (this.selectedPositionsList.isEmpty()) {
            return;
        }
        MCDataOutput out = this.getEditor().getToolStream(this);
        out.writeBoolean(this.overwrite);
        out.writeByte(this.wireType.ordinal());
        out.writeByte(this.selectedPositionsList.size());
        out.writeByte(this.selectedPositionsList.get((int)0).y);
        for (TileCoord t : this.selectedPositionsList) {
            out.writeByte(t.x).writeByte(t.z);
        }
    }

    protected boolean canPlaceAt(TileCoord pos, boolean overwrite) {
        if (!this.isInBody(pos) || this.isOnIOEdge(pos)) {
            return false;
        }
        return this.getEditor().getTileMap().getTile(pos).isEmpty() || overwrite;
    }

    protected void addToSelection(Vector3 mousePosition) {
        TileCoord pos = IICEditorTool.toNearestPosition(mousePosition);
        if (this.canPlaceAt(pos, this.overwrite) && !this.selectedPositionsSet.contains(pos)) {
            this.selectedPositionsSet.add(pos);
            this.selectedPositionsList.add(pos);
        }
    }

    @Override
    public boolean toolStart(Vector3 mousePosition, int glfwMouseButton) {
        if (glfwMouseButton == 0) {
            this.leftMouseDown = true;
            this.initialMouseDown.set(mousePosition);
            this.addToSelection(mousePosition);
            return true;
        }
        return false;
    }

    @Override
    public boolean toolReleased(Vector3 mousePosition, int glfwMouseButton) {
        if (glfwMouseButton == 0 && this.leftMouseDown) {
            this.addToSelection(mousePosition);
            this.sendPlaceWires();
            this.leftMouseDown = false;
            this.selectedPositionsSet.clear();
            this.selectedPositionsList.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean toolDragged(Vector3 mousePosition, Vector3 delta, int glfwMouseButton) {
        if (glfwMouseButton == 0 && this.leftMouseDown) {
            this.addToSelection(mousePosition);
            return true;
        }
        return false;
    }

    @Override
    public boolean toolScrolled(Vector3 mousePosition, double scroll) {
        return false;
    }

    @Override
    public void toolLayerChanged(int previousLayer, int newLayer) {
        if (this.leftMouseDown) {
            int diff = newLayer - previousLayer;
            this.initialMouseDown.y += (double)diff;
            LinkedList<TileCoord> oldSelection = new LinkedList<TileCoord>(this.selectedPositionsList);
            this.selectedPositionsSet.clear();
            this.selectedPositionsList.clear();
            for (TileCoord t : oldSelection) {
                TileCoord newPos = t.add(0, diff, 0);
                this.selectedPositionsSet.add(newPos);
                this.selectedPositionsList.add(newPos);
            }
        }
    }

    @Override
    public boolean toolCanceled() {
        if (this.leftMouseDown) {
            this.leftMouseDown = false;
            this.selectedPositionsSet.clear();
            this.selectedPositionsList.clear();
            return true;
        }
        return false;
    }

    @Override
    public void toolActivated() {
        this.leftMouseDown = false;
        this.selectedPositionsSet.clear();
        this.selectedPositionsList.clear();
    }

    @Override
    public void toolDeactivated() {
        this.leftMouseDown = false;
        this.selectedPositionsSet.clear();
        this.selectedPositionsList.clear();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(Vector3 mousePosition, boolean isFirstHit, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        TileCoord pos;
        if (!isFirstHit && this.selectedPositionsList.isEmpty()) {
            return;
        }
        ccrs.reset();
        ccrs.bind(ICRenderTypes.layersRenderType, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), matrixStack);
        ccrs.alphaOverride = this.leftMouseDown ? 128 : 64;
        ccrs.brightness = LightTexture.pack((int)15, (int)15);
        for (TileCoord pos2 : this.selectedPositionsList) {
            int rmask = 0;
            for (int r = 0; r < 4; ++r) {
                int s = IRotatableICTile.rotationToDir(r);
                if (!this.selectedPositionsSet.contains(pos2.offset(s))) continue;
                rmask |= 1 << r;
            }
            this.renderWireAt(pos2, ccrs, rmask);
        }
        if (!this.leftMouseDown && this.canPlaceAt(pos = IICEditorTool.toNearestPosition(mousePosition), this.overwrite)) {
            this.renderWireAt(pos, ccrs, 0);
        }
    }

    private void renderWireAt(TileCoord pos, CCRenderState ccrs, int rmask) {
        int wireConnMask = rmask << 4;
        int modelKey = WireModelRenderer.modelKey((int)0, (int)this.wireType.multipartType.getThickness(), (int)wireConnMask);
        WireModelRenderer.render((CCRenderState)ccrs, (int)modelKey, (int)-1, (TextureAtlasSprite)((TextureAtlasSprite)this.wireType.multipartType.getTextures().get(0)), (Transformation)new Translation((double)pos.x, (double)pos.y, (double)pos.z));
    }
}

