/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import mrtjp.projectred.fabrication.engine.IConnectableICTile;
import mrtjp.projectred.fabrication.engine.IRedstoneConnectableICTile;
import mrtjp.projectred.fabrication.engine.gates.GateTile;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import net.minecraft.nbt.CompoundTag;

public abstract class RedstoneGateTile
extends GateTile
implements IRedstoneConnectableICTile {
    public static final int STATE_PACKET = 5;
    private byte gateState = 0;

    public RedstoneGateTile(ICGateTileType gateType) {
        super(gateType);
    }

    public void setState(int state) {
        this.gateState = (byte)state;
    }

    public int getState() {
        return this.gateState & 0xFF;
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.putByte("state", this.gateState);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.gateState = tag.getByte("state");
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
        out.writeByte((int)this.gateState);
    }

    @Override
    public void readDesc(MCDataInput in) {
        super.readDesc(in);
        this.gateState = in.readByte();
    }

    @Override
    public void read(MCDataInput in, int key) {
        switch (key) {
            case 5: {
                this.gateState = in.readByte();
                break;
            }
            default: {
                super.read(in, key);
            }
        }
    }

    protected void sendStateUpdate() {
        this.getWriteStream(5).writeByte((int)this.gateState);
    }

    public int state() {
        return this.gateState & 0xFF;
    }

    @Override
    protected boolean canGateConnectTo(IConnectableICTile target, int r) {
        if (target instanceof IRedstoneConnectableICTile) {
            return this.canConnectRedstone(r);
        }
        return false;
    }

    protected boolean canConnectRedstone(int r) {
        return this.canInputRedstone(r) || this.canOutputRedstone(r);
    }

    protected boolean canOutputRedstone(int r) {
        return (this.redstoneOutputMask() & 1 << r) != 0;
    }

    protected boolean canInputRedstone(int r) {
        return (this.redstoneInputMask() & 1 << r) != 0;
    }

    protected int redstoneOutputMask() {
        return 0;
    }

    protected int redstoneInputMask() {
        return 0;
    }
}

