/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Vector3;
import java.util.List;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.editor.tools.SimpleInteractionZone;
import mrtjp.projectred.fabrication.engine.ICInterfaceType;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.SingleBitIOGateTile;
import net.minecraft.network.chat.Component;

public class RedstoneIOGateTile
extends SingleBitIOGateTile {
    private static final Cuboid6[] INPUT_TOGGLE_ZONE_BOUNDS = new Cuboid6[4];
    private static final Cuboid6[] DIR_ZONE_BOUNDS = new Cuboid6[4];

    public RedstoneIOGateTile() {
        super(ICGateTileType.REDSTONE_IO);
    }

    @Override
    public ICInterfaceType getInterfaceType() {
        return ICInterfaceType.REDSTONE;
    }

    @Override
    public void buildInteractionZoneList(List<InteractionZone> zones) {
        super.buildInteractionZoneList(zones);
        zones.add(new SimpleInteractionZone.Builder().bounds(() -> INPUT_TOGGLE_ZONE_BOUNDS[this.getRotation()]).leftClickAction(this::toggleWorldInput).tooltip(toolTip -> toolTip.add(Component.translatable((String)(this.isInputIOMode() ? "projectred_fabrication.interact.io_rs_input" : "projectred_fabrication.interact.io_rs_output")).append((Component)Component.literal((String)": ").append((Component)Component.translatable((String)((this.getState() & 0x44) != 0 ? "projectred_fabrication.interact.io_level_high" : "projectred_fabrication.interact.io_level_low")))).withStyle(ICWorkbenchEditor.UNIFORM_GRAY))).build());
        zones.add(new SimpleInteractionZone.Builder().bounds(() -> DIR_ZONE_BOUNDS[this.getRotation()]).leftClickAction(this::toggleDirection).tooltip(toolTip -> toolTip.add(Component.translatable((String)"projectred_fabrication.interact.io_direction").append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)(this.isInputIOMode() ? "projectred_fabrication.interact.io_direction.input" : "projectred_fabrication.interact.io_direction.output"))).withStyle(ICWorkbenchEditor.UNIFORM_GRAY))).build());
    }

    static {
        for (int r = 0; r < 4; ++r) {
            TransformationList t = new Scale(0.0625).with(Rotation.quarterRotations[r].at(Vector3.CENTER));
            RedstoneIOGateTile.INPUT_TOGGLE_ZONE_BOUNDS[r] = new Cuboid6(1.0, 2.0, 0.0, 15.0, 3.0, 3.0).apply((Transformation)t);
            RedstoneIOGateTile.DIR_ZONE_BOUNDS[r] = new Cuboid6(6.0, 2.0, 8.0, 10.0, 4.0, 12.0).apply((Transformation)t);
        }
    }
}

