/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.List;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.editor.tools.SimpleInteractionZone;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.InternalStateGateTile;
import net.minecraft.network.chat.Component;

public class ToggleLatchGateTile
extends InternalStateGateTile {
    private static final Cuboid6[] LEVER_ZONE_BOUNDS = new Cuboid6[4];

    public ToggleLatchGateTile() {
        super(ICGateTileType.TOGGLE_LATCH);
    }

    @Override
    public void buildInteractionZoneList(List<InteractionZone> zones) {
        super.buildInteractionZoneList(zones);
        zones.add(new SimpleInteractionZone.Builder().bounds(() -> LEVER_ZONE_BOUNDS[this.getRotation()]).leftClickAction(this::toggleDefaultState).tooltip(toolTip -> toolTip.add(Component.translatable((String)"projectred_fabrication.interact.default_state").append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)(this.getShape() == 0 ? "projectred_fabrication.tooltip.top" : "projectred_fabrication.tooltip.bottom"))).withStyle(ICWorkbenchEditor.UNIFORM_GRAY))).build());
    }

    protected void toggleDefaultState() {
        this.configureShapeAndSend((this.getShape() + 1) % 2);
    }

    @Override
    protected int redstoneInputMask() {
        return 10;
    }

    @Override
    protected int redstoneOutputMask() {
        return 5;
    }

    @Override
    public int state() {
        if (this.getEditor().getStateMachine().isSimulating()) {
            return super.state();
        }
        return this.getShape() == 0 ? 16 : 64;
    }

    @Override
    protected void collectGate(ICAssemblyTile.Collector collector, int gateId, int[] inputRegisters, int[] outputRegisters) {
        ArrayList<Integer> inputRegs = new ArrayList<Integer>();
        ArrayList<Integer> outputRegs = new ArrayList<Integer>();
        inputRegs.add(this.stateReg);
        inputRegs.add(inputRegisters[3]);
        inputRegs.add(inputRegisters[1]);
        outputRegs.add(this.stateReg);
        outputRegs.add(outputRegisters[0]);
        outputRegs.add(outputRegisters[2]);
        collector.addGate(gateId, new ToggleLatchGate(this.getShape()), inputRegs, outputRegs);
    }

    static {
        for (int r = 0; r < 4; ++r) {
            TransformationList t = new Scale(0.0625).with(Rotation.quarterRotations[r].at(Vector3.CENTER));
            ToggleLatchGateTile.LEVER_ZONE_BOUNDS[r] = new Cuboid6(9.0, 2.0, 4.0, 13.0, 4.0, 12.0).apply((Transformation)t);
        }
    }

    public static class ToggleLatchGate
    implements ICGate {
        private final int defaultState;

        public ToggleLatchGate(int defaultState) {
            this.defaultState = defaultState;
        }

        private static byte readState(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[0]);
        }

        private static int readInputMask(ICSimulation ic, int[] inputs) {
            int mask = 0;
            if (ic.getRegByteVal(inputs[1]) != 0) {
                mask |= 1;
            }
            if (ic.getRegByteVal(inputs[2]) != 0) {
                mask |= 2;
            }
            return mask;
        }

        private static void writeState(ICSimulation ic, int[] outputs, byte state) {
            ic.queueRegByteVal(outputs[0], state);
        }

        private static void writeOutputMask(ICSimulation ic, int[] outputs, int mask) {
            ic.queueRegByteVal(outputs[1], (byte)((mask & 1) != 0 ? 1 : 0));
            ic.queueRegByteVal(outputs[2], (byte)((mask & 2) != 0 ? 1 : 0));
        }

        @Override
        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            byte s = ToggleLatchGate.readState(ic, inputs);
            int state = s & 0xF;
            int inputMask = ToggleLatchGate.readInputMask(ic, inputs);
            int prevInputMask = s >> 4 & 0xF;
            int highMask = inputMask & ~prevInputMask;
            int nextState = state;
            switch (state) {
                case 0: {
                    if (this.defaultState == 0) {
                        nextState = 1;
                        ToggleLatchGate.writeOutputMask(ic, outputs, 1);
                        break;
                    }
                    nextState = 2;
                    ToggleLatchGate.writeOutputMask(ic, outputs, 2);
                    break;
                }
                case 1: {
                    if (highMask != 1 && highMask != 2) break;
                    nextState = 2;
                    ToggleLatchGate.writeOutputMask(ic, outputs, 2);
                    break;
                }
                case 2: {
                    if (highMask != 1 && highMask != 2) break;
                    nextState = 1;
                    ToggleLatchGate.writeOutputMask(ic, outputs, 1);
                    break;
                }
                default: {
                    ProjectRedFabrication.LOGGER.error("Invalid state: " + ToggleLatchGate.readState(ic, inputs));
                    nextState = 0;
                }
            }
            ToggleLatchGate.writeState(ic, outputs, (byte)(inputMask << 4 | nextState));
        }
    }
}

