/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.wires;

import mrtjp.fengine.api.PropagationFunction;
import mrtjp.projectred.fabrication.engine.IBundledConnectableICTile;
import mrtjp.projectred.fabrication.engine.IConnectableICTile;
import mrtjp.projectred.fabrication.engine.IInsulatedConnectableICTile;
import mrtjp.projectred.fabrication.engine.IRedstoneConnectableICTile;
import mrtjp.projectred.fabrication.engine.wires.ICWireTileType;
import mrtjp.projectred.fabrication.engine.wires.RedstoneWireTile;
import mrtjp.projectred.transmission.WireType;

public class InsulatedWireTile
extends RedstoneWireTile
implements IInsulatedConnectableICTile,
IRedstoneConnectableICTile {
    public InsulatedWireTile(int colour) {
        super(ICWireTileType.INSULATED[colour].tileType, WireType.values()[WireType.INSULATED_WHITE.ordinal() + colour]);
    }

    @Override
    protected int getRenderHue() {
        return -1;
    }

    @Override
    public int getInsulatedColour() {
        return this.getWireType().getColourIdx();
    }

    @Override
    protected int getTextureIndex() {
        return this.signal != 0 ? 1 : 0;
    }

    @Override
    public boolean canConnectTo(IConnectableICTile target, int towardsDir) {
        if (target instanceof IInsulatedConnectableICTile) {
            return ((IInsulatedConnectableICTile)((Object)target)).getInsulatedColour() == this.getInsulatedColour();
        }
        if (target instanceof IBundledConnectableICTile) {
            return true;
        }
        return super.canConnectTo(target, towardsDir);
    }

    @Override
    public PropagationFunction propagationFunc(int inDir, int inPort) {
        return (outDir, outPort) -> inPort == this.getInsulatedColour() && outPort == inPort && this.maskConnectsToDir(inDir) && this.maskConnectsToDir(outDir);
    }
}

