/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui.screen;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.IICEditorTool;
import mrtjp.projectred.fabrication.engine.log.ICCompilerLog;
import mrtjp.projectred.fabrication.gui.CompileProblemsTab;
import mrtjp.projectred.fabrication.gui.CompileStackTab;
import mrtjp.projectred.fabrication.gui.CompileTreeTab;
import mrtjp.projectred.fabrication.gui.ICRenderNode;
import mrtjp.projectred.fabrication.gui.ICompileOverlayRenderer;
import mrtjp.projectred.fabrication.gui.SimpleUVTab;
import mrtjp.projectred.fabrication.gui.TabButtonNode;
import mrtjp.projectred.fabrication.gui.TabControllerNode;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractButtonNode;
import mrtjp.projectred.redui.AbstractCheckboxNode;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ICWorkbenchCompileTab
extends AbstractGuiNode
implements ICRenderNode.IICRenderNodeEventReceiver {
    public static final ResourceLocation TAB_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"projectred_fabrication", (String)"textures/gui/compile_tab.png");
    private final ICWorkbenchEditor editor;
    private final List<ICompileOverlayRenderer> overlays = new LinkedList<ICompileOverlayRenderer>();
    private boolean upPressed = false;
    private boolean rightPressed = false;
    private boolean downPressed = false;
    private boolean leftPressed = false;
    private boolean layerUpPressed = false;
    private boolean layerDownPressed = false;

    public ICWorkbenchCompileTab(ICWorkbenchEditor editor) {
        this.editor = editor;
        this.setSize(304, 222);
        this.initSubNodes();
    }

    private void initSubNodes() {
        CompileButton compileButton = new CompileButton();
        compileButton.setPosition(208, 16);
        compileButton.setSize(18, 18);
        this.addChild((RedUINode)compileButton);
        AutoCompileCheckbox autoCompileCheckbox = new AutoCompileCheckbox();
        autoCompileCheckbox.setPosition(230, 16);
        this.addChild((RedUINode)autoCompileCheckbox);
        ICRenderNode icRenderNode = new ICRenderNode(this.editor, this);
        icRenderNode.setPosition(7, 18);
        icRenderNode.setSize(197, 197);
        this.addChild((RedUINode)icRenderNode);
        CompileStackTab compileStackTab = new CompileStackTab(this.editor);
        compileStackTab.setPosition(208, 77);
        this.addChild((RedUINode)compileStackTab);
        CompileTreeTab compileTreeTab = new CompileTreeTab(this.editor);
        compileTreeTab.setPosition(208, 77);
        this.addChild((RedUINode)compileTreeTab);
        CompileProblemsTab compileProblemsTab = new CompileProblemsTab(this.editor);
        compileProblemsTab.setPosition(208, 77);
        this.addChild((RedUINode)compileProblemsTab);
        this.overlays.add(compileStackTab);
        this.overlays.add(compileTreeTab);
        this.overlays.add(compileProblemsTab);
        TabControllerNode tabControllerNode = new TabControllerNode();
        tabControllerNode.setPosition(212, 210);
        tabControllerNode.setZPosition(0.1);
        this.addChild((RedUINode)tabControllerNode);
        tabControllerNode.addButtonForTab(new SimpleUVTab(compileStackTab, "projectred_fabrication.tab.stack", TabButtonNode.TabSide.BOTTOM, 350, 11, TAB_BACKGROUND));
        tabControllerNode.addButtonForTab(new SimpleUVTab(compileTreeTab, "projectred_fabrication.tab.tree", TabButtonNode.TabSide.BOTTOM, 365, 11, TAB_BACKGROUND));
        tabControllerNode.addButtonForTab(new ProblemsTab(compileProblemsTab, "projectred_fabrication.tab.problems", TabButtonNode.TabSide.BOTTOM, 380, 11, TAB_BACKGROUND));
        tabControllerNode.selectInitialTab(0);
        tabControllerNode.spreadButtonsHorizontally(1);
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TAB_BACKGROUND);
        graphics.blit(TAB_BACKGROUND, this.getFrame().x(), this.getFrame().y(), 0.0f, 0.0f, this.getFrame().width(), this.getFrame().height(), 512, 512);
        graphics.drawString(this.getRoot().getFontRenderer(), this.editor.getIcName(), this.getFrame().x() + 8, this.getFrame().y() + 6, EnumColour.GRAY.argb(), false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TAB_BACKGROUND);
        int barWidth = 91;
        int progress = this.editor.getStateMachine().getCompilerLog().getProgressScaled(barWidth);
        graphics.blit(TAB_BACKGROUND, this.getFrame().x() + 208, this.getFrame().y() + 36, 304.0f, 0.0f, barWidth, 5, 512, 512);
        graphics.blit(TAB_BACKGROUND, this.getFrame().x() + 208, this.getFrame().y() + 36, 304.0f, 5.0f, progress, 5, 512, 512);
        ICCompilerLog log = this.editor.getStateMachine().getCompilerLog();
        graphics.drawString(this.getRoot().getFontRenderer(), (Component)Component.translatable((String)(this.editor.getStateMachine().isCompiling() ? "projectred_fabrication.ui.compile_progress" : "projectred_fabrication.ui.compile_done"), (Object[])new Object[]{log.getCompletedSteps(), log.getTotalSteps()}).withStyle(ICWorkbenchEditor.UNIFORM_DARK_GRAY), this.getFrame().x() + 208, this.getFrame().y() + 42, EnumColour.GRAY.argb(), false);
        MutableComponent errorText = log.getErrorCount() == 0 ? Component.literal((String)"<!> ").append((Component)Component.translatable((String)"projectred_fabrication.problems.no_errors")).withStyle(ICWorkbenchEditor.UNIFORM_DARK_GRAY) : Component.literal((String)"<!> ").withStyle(ICWorkbenchEditor.UNIFORM_RED).append((Component)Component.translatable((String)"projectred_fabrication.f.unit.errors", (Object[])new Object[]{log.getErrorCount()}).withStyle(ICWorkbenchEditor.UNIFORM_DARK_GRAY));
        MutableComponent warningText = log.getWarningCount() == 0 ? Component.literal((String)"<!> ").append((Component)Component.translatable((String)"projectred_fabrication.problems.no_warnings")).withStyle(ICWorkbenchEditor.UNIFORM_DARK_GRAY) : Component.literal((String)"<!> ").withStyle(ICWorkbenchEditor.UNIFORM_YELLOW).append((Component)Component.translatable((String)"projectred_fabrication.f.unit.warnings", (Object[])new Object[]{log.getWarningCount()}).withStyle(ICWorkbenchEditor.UNIFORM_DARK_GRAY));
        graphics.drawString(this.getRoot().getFontRenderer(), (Component)errorText, this.getFrame().x() + 208, this.getFrame().y() + 52, EnumColour.GRAY.argb(), false);
        graphics.drawString(this.getRoot().getFontRenderer(), (Component)warningText, this.getFrame().x() + 208, this.getFrame().y() + 60, EnumColour.GRAY.argb(), false);
    }

    public boolean onKeyPressed(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        if (consumed || this.isHidden()) {
            return false;
        }
        switch (glfwKeyCode) {
            case 87: {
                this.upPressed = true;
                break;
            }
            case 65: {
                this.leftPressed = true;
                break;
            }
            case 83: {
                this.downPressed = true;
                break;
            }
            case 68: {
                this.rightPressed = true;
                break;
            }
            case 265: {
                this.layerUpPressed = true;
                break;
            }
            case 264: {
                this.layerDownPressed = true;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean onKeyReleased(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        switch (glfwKeyCode) {
            case 87: {
                this.upPressed = false;
                break;
            }
            case 65: {
                this.leftPressed = false;
                break;
            }
            case 83: {
                this.downPressed = false;
                break;
            }
            case 68: {
                this.rightPressed = false;
                break;
            }
            case 265: {
                this.layerUpPressed = false;
                break;
            }
            case 264: {
                this.layerDownPressed = false;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void update(ICRenderNode renderNode) {
        if (this.upPressed || this.downPressed || this.leftPressed || this.rightPressed) {
            Vector3 panDelta = new Vector3();
            double deltaPerTick = 0.05;
            panDelta.z = (this.upPressed ? -deltaPerTick : 0.0) + (this.downPressed ? deltaPerTick : 0.0);
            panDelta.x = (this.leftPressed ? -deltaPerTick : 0.0) + (this.rightPressed ? deltaPerTick : 0.0);
            renderNode.applyPanningDelta(panDelta);
        }
        if (this.layerUpPressed) {
            renderNode.setLayer(renderNode.getLayer() + 1);
        } else if (this.layerDownPressed) {
            renderNode.setLayer(renderNode.getLayer() - 1);
        }
        this.layerUpPressed = false;
        this.layerDownPressed = false;
    }

    @Override
    public void mouseScrolled(ICRenderNode renderNode, Vector3 mousePosition, double scroll) {
        renderNode.moveZoomAt(mousePosition, scroll * 0.3);
    }

    @Override
    public void buildTooltip(ICRenderNode renderNode, Vector3 mousePosition, boolean isFirstHit, List<Component> tooltip) {
        if (!isFirstHit) {
            return;
        }
        TileCoord pos = IICEditorTool.toNearestPosition(mousePosition);
        this.editor.getTileMap().getBaseTile(pos).ifPresent(tile -> tile.buildToolTip(tooltip));
        for (ICompileOverlayRenderer overlay : this.overlays) {
            overlay.buildTooltip(renderNode, mousePosition, tooltip);
        }
    }

    @Override
    public void onRenderOverlay(ICRenderNode renderNode, Vector3 mousePosition, boolean isFirstHit, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        for (ICompileOverlayRenderer overlay : this.overlays) {
            overlay.renderOverlay(renderNode, mousePosition, isFirstHit, ccrs, getter, matrixStack);
        }
    }

    public static void appendProblemsInfo(ICCompilerLog log, List<Component> tooltip) {
        MutableComponent errorText = log.getErrorCount() == 0 ? Component.literal((String)"<!> ").append((Component)Component.translatable((String)"projectred_fabrication.problems.no_errors")).withStyle(ICWorkbenchEditor.UNIFORM_GRAY) : Component.literal((String)"<!> ").withStyle(ICWorkbenchEditor.UNIFORM_RED).append((Component)Component.translatable((String)"projectred_fabrication.f.unit.errors", (Object[])new Object[]{log.getErrorCount()}).withStyle(ICWorkbenchEditor.UNIFORM_GRAY));
        MutableComponent warningText = log.getWarningCount() == 0 ? Component.literal((String)"<!> ").append((Component)Component.translatable((String)"projectred_fabrication.problems.no_warnings")).withStyle(ICWorkbenchEditor.UNIFORM_GRAY) : Component.literal((String)"<!> ").withStyle(ICWorkbenchEditor.UNIFORM_YELLOW).append((Component)Component.translatable((String)"projectred_fabrication.f.unit.warnings", (Object[])new Object[]{log.getWarningCount()}).withStyle(ICWorkbenchEditor.UNIFORM_GRAY));
        tooltip.add((Component)errorText);
        tooltip.add((Component)warningText);
    }

    public class CompileButton
    extends AbstractButtonNode {
        protected void onButtonClicked() {
            ICWorkbenchCompileTab.this.editor.getStateMachine().sendCompileButtonClicked();
        }

        protected boolean isButtonDisabled() {
            return !ICWorkbenchCompileTab.this.editor.getStateMachine().canTriggerCompile();
        }

        protected void drawButtonBody(GuiGraphics graphics, boolean mouseover) {
            if (ICWorkbenchCompileTab.this.editor.getStateMachine().isCompiling()) {
                long time = Minecraft.getInstance().level.getGameTime();
                int progress = (int)(time / 2L) % 8;
                int u = 305 + 15 * progress;
                int v = 26;
                this.blitCentered(graphics, TAB_BACKGROUND, u, v, 14, 14);
            } else {
                this.blitCentered(graphics, TAB_BACKGROUND, 305, 11, 14, 14);
            }
        }

        private void blitCentered(GuiGraphics graphics, ResourceLocation background, int u, int v, int width, int height) {
            graphics.blit(background, this.getFrame().x() + (this.getFrame().width() - width) / 2, this.getFrame().y() + (this.getFrame().height() - height) / 2, (float)u, (float)v, width, height, 512, 512);
        }

        protected void buildTooltip(List<Component> tooltip) {
            tooltip.add((Component)Component.translatable((String)"projectred_fabrication.ui.compile"));
            if (ICWorkbenchCompileTab.this.editor.getStateMachine().canTriggerCompile()) {
                tooltip.add((Component)Component.translatable((String)"projectred_fabrication.ui.compile_ready").withStyle(ICWorkbenchEditor.UNIFORM_GRAY));
            }
        }
    }

    private class AutoCompileCheckbox
    extends AbstractCheckboxNode {
        private AutoCompileCheckbox() {
        }

        protected boolean isDisabled() {
            return !ICWorkbenchCompileTab.this.editor.getStateMachine().isAutoCompileAvailable();
        }

        protected boolean isChecked() {
            return ICWorkbenchCompileTab.this.editor.getStateMachine().isAutoCompileEnabled();
        }

        protected void onClicked() {
            ICWorkbenchCompileTab.this.editor.getStateMachine().sendAutoCompileToggled();
        }

        protected void buildTooltip(List<Component> tooltip) {
            tooltip.add((Component)Component.translatable((String)"projectred_fabrication.ui.auto_compile"));
            tooltip.add((Component)Component.translatable((String)"projectred_fabrication.ui.auto_compile_description").withStyle(ICWorkbenchEditor.UNIFORM_GRAY));
            if (this.isDisabled()) {
                tooltip.add((Component)Component.literal((String)"<!> ").withStyle(ICWorkbenchEditor.UNIFORM_RED).append((Component)Component.translatable((String)"projectred_fabrication.ui.auto_compile_disabled").withStyle(ICWorkbenchEditor.UNIFORM_GRAY)));
            }
        }
    }

    private class ProblemsTab
    extends SimpleUVTab {
        public ProblemsTab(AbstractGuiNode tabBodyNode, String unlocalTabName, TabButtonNode.TabSide side, int u, int v, ResourceLocation texture) {
            super(tabBodyNode, unlocalTabName, side, u, v, texture);
        }

        @Override
        protected SimpleUVTab.StatusDot getStatusDot() {
            if (ICWorkbenchCompileTab.this.editor.getStateMachine().getCompilerLog().getErrorCount() > 0) {
                return SimpleUVTab.StatusDot.RED;
            }
            if (ICWorkbenchCompileTab.this.editor.getStateMachine().getCompilerLog().getWarningCount() > 0) {
                return SimpleUVTab.StatusDot.YELLOW;
            }
            return SimpleUVTab.StatusDot.NONE;
        }

        @Override
        protected void buildTooltip(List<Component> tooltip) {
            super.buildTooltip(tooltip);
            ICCompilerLog log = ICWorkbenchCompileTab.this.editor.getStateMachine().getCompilerLog();
            ICWorkbenchCompileTab.appendProblemsInfo(log, tooltip);
        }
    }
}

