/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.inventory.container;

import codechicken.lib.inventory.container.CCLMenuType;
import mrtjp.projectred.core.inventory.container.TakeOnlySlot;
import mrtjp.projectred.fabrication.init.FabricationMenus;
import mrtjp.projectred.fabrication.inventory.container.FabricationMachineMenu;
import mrtjp.projectred.fabrication.item.BlankPhotomaskItem;
import mrtjp.projectred.fabrication.item.ICBlueprintItem;
import mrtjp.projectred.fabrication.tile.PlottingTableBlockEntity;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PlottingTableMenu
extends FabricationMachineMenu {
    public static CCLMenuType<PlottingTableMenu> FACTORY = (windowId, inventory, packet) -> {
        BlockEntity tile = inventory.player.level().getBlockEntity(packet.readPos());
        if (!(tile instanceof PlottingTableBlockEntity)) {
            return null;
        }
        return new PlottingTableMenu(inventory, (PlottingTableBlockEntity)tile, windowId);
    };
    private final Inventory playerInventory;
    private final PlottingTableBlockEntity tile;

    public PlottingTableMenu(Inventory playerInventory, PlottingTableBlockEntity tile, int windowId) {
        super(FabricationMenus.PLOTTING_TABLE_MENU.get(), windowId, tile);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)playerInventory, (int)8, (int)89, x$0 -> this.addSlot((Slot)x$0));
        this.addPlottingTableInventory();
    }

    private void addPlottingTableInventory() {
        this.addSlot(new Slot(this.tile.getInventory(), 0, 56, 31));
        this.addSlot(new Slot(this.tile.getInventory(), 1, 56, 49));
        this.addSlot((Slot)new TakeOnlySlot(this.tile.getInventory(), 2, 116, 40));
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (this.isOutput(slotIndex) ? !this.moveToEntireInventory(stack, true) : (this.isHotbar(slotIndex) || this.isPlayerInventory(slotIndex) ? (this.isBlueprint(stack) ? !this.moveToBlueprintInput(stack, false) : (this.isBlankPhotomask(stack) ? !this.moveToPhotomaskInput(stack, false) : (this.isPlayerInventory(slotIndex) ? !this.moveToHotbar(stack, false) : !this.moveToPlayerInventory(stack, false)))) : this.isInputs(slotIndex) && !this.moveToEntireInventory(stack, false))) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == originalStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return originalStack;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isInputs(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 38;
    }

    private boolean isOutput(int slotIndex) {
        return slotIndex == 38;
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 27, 36, reverse);
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 27, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 36, reverse);
    }

    private boolean moveToBlueprintInput(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 36, 37, reverse);
    }

    private boolean moveToPhotomaskInput(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 37, 38, reverse);
    }

    private boolean isBlueprint(ItemStack stack) {
        return stack.getItem() instanceof ICBlueprintItem;
    }

    private boolean isBlankPhotomask(ItemStack stack) {
        return stack.getItem() instanceof BlankPhotomaskItem;
    }
}

