/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.item;

import java.util.List;
import mrtjp.projectred.fabrication.lithography.WaferType;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class BaseSiliconWaferItem
extends Item {
    private final WaferType waferType;

    public BaseSiliconWaferItem(WaferType waferType) {
        super(new Item.Properties());
        this.waferType = waferType;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipList, tooltipFlag);
        tooltipList.add((Component)Component.translatable((String)"projectred_fabrication.tooltip.size").append(": " + this.waferType.getWaferWidth() + "nm x " + this.waferType.getWaferHeight() + "nm").withStyle(ChatFormatting.GRAY));
        tooltipList.add((Component)Component.translatable((String)"projectred_fabrication.tooltip.defect_chance").append(": %.2e%% / nm^2".formatted(this.waferType.getDefectRatePerUnitArea() * 100.0)).withStyle(ChatFormatting.GRAY));
    }

    public WaferType getWaferType() {
        return this.waferType;
    }
}

