/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.editor;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Function;
import javax.annotation.Nullable;
import mrtjp.fengine.api.ICFlatMap;
import mrtjp.fengine.api.ICStepThroughAssembler;
import mrtjp.fengine.tiles.FETileMap;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.engine.BaseTile;
import mrtjp.projectred.fabrication.engine.ICInterfaceType;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.IIOConnectionTile;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.engine.log.ICCompilerLog;
import mrtjp.projectred.fabrication.engine.log.IODirectionMismatchError;
import mrtjp.projectred.fabrication.engine.log.IOTypeMismatchError;
import mrtjp.projectred.fabrication.engine.log.NoInputsError;
import mrtjp.projectred.fabrication.engine.log.NoOutputsError;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ICEditorStateMachine {
    public static final int KEY_STATE_CHANGED = 0;
    public static final int KEY_COMPILER_LOG_CLEARED = 1;
    public static final int KEY_COMPILER_LOG_NODE_ADDED = 2;
    public static final int KEY_COMPILER_LOG_NODE_EXECUTED = 3;
    public static final int KEY_COMPILER_LOG_PROBLEM_ADDED = 4;
    public static final int KEY_AUTO_COMPILE_STATE = 5;
    public static final int KEY_SIM_START_TIME_CHANGED = 6;
    public static final int KEY_CLIENT_COMPILE_CLICKED = 10;
    public static final int KEY_CLIENT_AUTO_COMPILE_TOGGLED = 11;
    private final ICWorkbenchEditor editor;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_AWAITING_COMPILE = 1;
    private static final int STATE_COMPILING = 2;
    private static final int STATE_SIMULATING = 3;
    private static final int STATE_COMPILE_FAILED = 4;
    private final State[] states = new State[]{new StateInitial(), new StateAwaitingCompile(), new StateCompiling(), new StateSimulating(), new CompileFailed()};
    private int currentState = 0;
    @Nullable
    private final StateMachineCallback callback;
    private final ICSimulationContainer simulationContainer = new ICSimulationContainer();
    private final ICCompilerLog compilerLog = new ICCompilerLog(this);
    private int lastCompiledFormat = 0;
    private long lastSimStartTime = 0L;
    private String lastCompiledFlatMap = PRFabricationEngine.EMPTY_FLAT_MAP_SERIALIZED;
    private boolean autoCompileAvailable = true;
    private boolean enableAutoCompile = true;

    public ICEditorStateMachine(ICWorkbenchEditor editor, @Nullable StateMachineCallback callback) {
        this.editor = editor;
        this.callback = callback;
    }

    public ICCompilerLog getCompilerLog() {
        return this.compilerLog;
    }

    public int getLastCompiledFormat() {
        return this.lastCompiledFormat;
    }

    public String getLastCompiledFlatMap() {
        return this.lastCompiledFlatMap;
    }

    public void save(CompoundTag tag) {
        tag.putByte("state", (byte)this.currentState);
        tag.putInt("compile_format", this.lastCompiledFormat);
        tag.putLong("sim_start_time", this.editor.getGameTime() - this.lastSimStartTime);
        tag.putString("flat_map", this.lastCompiledFlatMap);
        CompoundTag simTag = new CompoundTag();
        this.simulationContainer.save(simTag);
        tag.put("sim_cont", (Tag)simTag);
        CompoundTag logTag = new CompoundTag();
        this.compilerLog.save(logTag);
        tag.put("compiler_log", (Tag)logTag);
        tag.putBoolean("auto_compile_enable", this.enableAutoCompile);
        tag.putBoolean("auto_compile_allowed", this.autoCompileAvailable);
    }

    public void load(CompoundTag tag) {
        this.currentState = tag.getByte("state") & 0xFF;
        this.lastCompiledFormat = tag.getInt("compile_format");
        this.lastCompiledFlatMap = tag.getString("flat_map");
        this.simulationContainer.load(tag.getCompound("sim_cont"));
        this.compilerLog.load(tag.getCompound("compiler_log"));
        this.enableAutoCompile = tag.getBoolean("auto_compile_enable");
        this.autoCompileAvailable = tag.getBoolean("auto_compile_allowed");
    }

    public void writeDesc(MCDataOutput out) {
        out.writeByte(this.currentState);
        out.writeLong(this.lastSimStartTime);
        this.simulationContainer.writeDesc(out);
        this.compilerLog.writeDesc(out);
        this.writeAutoCompileState(out);
    }

    public void readDesc(MCDataInput in) {
        this.currentState = in.readUByte();
        this.lastSimStartTime = in.readLong();
        this.simulationContainer.readDesc(in);
        this.compilerLog.readDesc(in);
        this.readAutoCompileState(in);
    }

    public void reset() {
        this.enterState(0, true);
    }

    public void readStateMachineStream(MCDataInput in, int key) {
        switch (key) {
            case 0: {
                this.enterStateOnClient(in.readUByte());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.compilerLog.readLogStream(in, key);
                break;
            }
            case 5: {
                this.readAutoCompileState(in);
                break;
            }
            case 6: {
                this.lastSimStartTime = in.readLong();
                break;
            }
            case 10: {
                this.onCompileTriggered();
                break;
            }
            case 11: {
                this.setAutoCompileAndSend(!this.enableAutoCompile);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compiler stream key: " + key);
            }
        }
    }

    public MCDataOutput getStateMachineStream(int key) {
        return this.editor.getStateMachineStream(key);
    }

    public void onChunkLoad() {
        this.lastSimStartTime = this.editor.getGameTime() - this.lastSimStartTime;
    }

    public void onTick(long time) {
        this.assertServer();
        this.states[this.currentState].onTick(time);
    }

    public void onTileMapChanged() {
        this.assertServer();
        this.states[this.currentState].onTileMapChanged();
    }

    public void onCompileTriggered() {
        this.assertServer();
        this.states[this.currentState].onCompileTriggered();
    }

    public void onInputRegistersChanged(int rotation, Function<Short, Short> changeFunction) {
        this.assertServer();
        this.states[this.currentState].onInputRegistersChanged(rotation, changeFunction);
    }

    private void sendAutoCompileState() {
        this.writeAutoCompileState(this.getStateMachineStream(5));
    }

    private boolean checkAutoCompileAvailable() {
        if ((Integer)Configurator.SERVER.autoCompileTileLimit.get() == -1) {
            return true;
        }
        if ((Integer)Configurator.SERVER.autoCompileTileLimit.get() == 0) {
            return false;
        }
        return this.editor.getTileMap().getTileCount() <= (Integer)Configurator.SERVER.autoCompileTileLimit.get();
    }

    private void setAutoCompileAndSend(boolean enable) {
        boolean oldAvailable = this.autoCompileAvailable;
        boolean oldEnabled = this.enableAutoCompile;
        this.autoCompileAvailable = this.checkAutoCompileAvailable();
        boolean bl = this.enableAutoCompile = this.autoCompileAvailable && enable;
        if (oldAvailable != this.autoCompileAvailable || oldEnabled != this.enableAutoCompile) {
            this.sendAutoCompileState();
        }
    }

    private void writeAutoCompileState(MCDataOutput out) {
        int acState = (this.autoCompileAvailable ? 1 : 0) | (this.enableAutoCompile ? 2 : 0);
        out.writeByte(acState);
    }

    private void setLastSimStartTimeAndSend(long time) {
        if (time == this.lastSimStartTime) {
            return;
        }
        this.lastSimStartTime = time;
        this.getStateMachineStream(6).writeLong(time);
    }

    private void assertServer() {
        if (this.editor.isClientSide()) {
            throw new RuntimeException("Server-side operation performed on client! Report to ProjectRed developers");
        }
    }

    private void readAutoCompileState(MCDataInput in) {
        byte acState = in.readByte();
        this.autoCompileAvailable = (acState & 1) != 0;
        this.enableAutoCompile = (acState & 2) != 0;
    }

    public void sendCompileButtonClicked() {
        this.getStateMachineStream(10);
    }

    public void sendAutoCompileToggled() {
        this.getStateMachineStream(11);
    }

    public boolean canTriggerCompile() {
        return this.states[this.currentState].canTransitionTo(2);
    }

    public boolean isCompiling() {
        return this.currentState == 2;
    }

    public boolean isSimulating() {
        return this.currentState == 3;
    }

    public boolean didLastCompileFailed() {
        return this.getCompilerLog().getErrorCount() > 0;
    }

    public boolean isAutoCompileEnabled() {
        return this.enableAutoCompile;
    }

    public boolean isAutoCompileAvailable() {
        return this.autoCompileAvailable;
    }

    public long getSimSystemTime() {
        return this.editor.getGameTime() - this.lastSimStartTime;
    }

    private void enterState(int id, boolean force) {
        if (this.currentState == id) {
            return;
        }
        if (!force && !this.states[this.currentState].canTransitionTo(id)) {
            throw new RuntimeException("Illegal state change requested");
        }
        int oldState = this.currentState;
        this.states[this.currentState].onStateLeaving(id);
        this.currentState = id;
        this.states[this.currentState].onStateEntered(oldState);
        ProjectRedFabrication.LOGGER.debug("State transition: " + oldState + " -> " + this.currentState);
        this.editor.markDirty();
    }

    private void enterStateAndSend(int id) {
        this.enterState(id, false);
        this.getStateMachineStream(0).writeByte(this.currentState);
    }

    private void enterStateOnClient(int id) {
        int oldState = this.currentState;
        this.states[this.currentState].onClientStateLeaving(id);
        this.currentState = id;
        this.states[this.currentState].onClientStateEntered(oldState);
        ProjectRedFabrication.LOGGER.debug("Client state transition: " + oldState + " -> " + this.currentState);
    }

    private static interface State {
        default public void onTick(long time) {
        }

        default public void onTileMapChanged() {
        }

        default public void onCompileTriggered() {
        }

        default public void onInputRegistersChanged(int rotation, Function<Short, Short> changeFunction) {
        }

        public boolean canTransitionTo(int var1);

        default public void onStateEntered(int previousStateId) {
        }

        default public void onStateLeaving(int nextStateId) {
        }

        default public void onClientStateEntered(int previousStateId) {
        }

        default public void onClientStateLeaving(int nextStateId) {
        }
    }

    private class StateInitial
    implements State {
        private StateInitial() {
        }

        @Override
        public void onTileMapChanged() {
            ICEditorStateMachine.this.enterStateAndSend(1);
        }

        @Override
        public boolean canTransitionTo(int id) {
            return id == 1;
        }

        @Override
        public void onStateEntered(int previousStateId) {
            ICEditorStateMachine.this.compilerLog.clearAndSend();
        }
    }

    private class StateAwaitingCompile
    implements State {
        private StateAwaitingCompile() {
        }

        @Override
        public void onTick(long time) {
            if (ICEditorStateMachine.this.enableAutoCompile) {
                ICEditorStateMachine.this.enterStateAndSend(2);
            }
        }

        @Override
        public void onCompileTriggered() {
            ICEditorStateMachine.this.enterStateAndSend(2);
        }

        @Override
        public boolean canTransitionTo(int id) {
            return id == 2;
        }

        @Override
        public void onStateEntered(int previousStateId) {
            ICEditorStateMachine.this.setAutoCompileAndSend(ICEditorStateMachine.this.enableAutoCompile);
        }

        @Override
        public void onTileMapChanged() {
            ICEditorStateMachine.this.setAutoCompileAndSend(ICEditorStateMachine.this.enableAutoCompile);
        }
    }

    private class StateCompiling
    implements State {
        @Nullable
        private ICStepThroughAssembler assembler = null;

        private StateCompiling() {
        }

        @Override
        public void onTick(long time) {
            if (this.assembler == null) {
                ProjectRedFabrication.LOGGER.warn("Compiler assembler is null!");
                this.restartAssembly();
                return;
            }
            if (!this.assembler.isDone()) {
                long elapsedTime;
                long nanoTime = System.nanoTime();
                do {
                    this.assembler.stepIn();
                } while ((elapsedTime = System.nanoTime() - nanoTime) < 500000L && !this.assembler.isDone());
            }
            if (this.assembler.isDone()) {
                ICFlatMap map = this.assembler.result();
                this.assembler = null;
                ICEditorStateMachine.this.lastCompiledFormat = 1;
                ICEditorStateMachine.this.lastCompiledFlatMap = PRFabricationEngine.instance.serializeFlatMap(map);
                ICEditorStateMachine.this.simulationContainer.setSystemTime(0L);
                ICEditorStateMachine.this.simulationContainer.setFlatMap(map);
                if (ICEditorStateMachine.this.compilerLog.getErrorCount() > 0) {
                    ICEditorStateMachine.this.enterStateAndSend(4);
                    if (ICEditorStateMachine.this.callback != null) {
                        ICEditorStateMachine.this.callback.onCompileFailed();
                    }
                } else {
                    ICEditorStateMachine.this.enterStateAndSend(3);
                    if (ICEditorStateMachine.this.callback != null) {
                        ICEditorStateMachine.this.callback.onCompileComplete();
                    }
                }
            }
        }

        @Override
        public void onTileMapChanged() {
            this.restartAssembly();
        }

        @Override
        public boolean canTransitionTo(int id) {
            return id == 3 || id == 4;
        }

        @Override
        public void onStateEntered(int previousStateId) {
            this.restartAssembly();
        }

        @Override
        public void onStateLeaving(int nextStateId) {
            this.assembler = null;
        }

        private void restartAssembly() {
            int r;
            this.assembler = PRFabricationEngine.instance.newStepThroughAssembler();
            this.assembler.setEventReceiver((ICStepThroughAssembler.EventReceiver)ICEditorStateMachine.this.compilerLog);
            ICEditorStateMachine.this.compilerLog.clearAndSend();
            this.assembler.addTileMap((FETileMap)ICEditorStateMachine.this.editor.getTileMap(), Collections.emptyMap());
            if (ICEditorStateMachine.this.callback != null) {
                ICEditorStateMachine.this.callback.onCompileStart();
            }
            int ioMask = 0;
            Collection<IIOConnectionTile> ioTiles = ICEditorStateMachine.this.editor.getTileMap().getIOTiles();
            for (IIOConnectionTile io2 : ioTiles) {
                int s = io2.getIOSide();
                int m = io2.isInputIOMode() ? 1 : 2;
                ioMask |= m << s * 2;
            }
            for (r = 0; r < 4; ++r) {
                int m = ioMask >> r * 2 & 3;
                if (m != 3) continue;
                int finalR = r;
                ArrayList coordList = FastStream.of(ioTiles).filter(io -> io.getIOSide() == finalR).map(io -> ((BaseTile)((Object)io)).getPos()).toList();
                ICEditorStateMachine.this.compilerLog.addProblem(new IODirectionMismatchError(coordList));
            }
            for (r = 0; r < 4; ++r) {
                int finalR = r;
                ArrayList rIO = FastStream.of(ioTiles).filter(io -> io.getIOSide() == finalR).toList();
                HashSet typeSet = FastStream.of((Iterable)rIO).map(IIOConnectionTile::getInterfaceType).filter(t -> t != ICInterfaceType.NC).toSet();
                if (typeSet.size() <= 1) continue;
                ArrayList coordList = FastStream.of((Iterable)rIO).map(io -> ((BaseTile)((Object)io)).getPos()).toList();
                ICEditorStateMachine.this.compilerLog.addProblem(new IOTypeMismatchError(coordList));
            }
            if ((ioMask & 0x55) == 0) {
                ICEditorStateMachine.this.compilerLog.addProblem(new NoInputsError());
            }
            if ((ioMask & 0xAA) == 0) {
                ICEditorStateMachine.this.compilerLog.addProblem(new NoOutputsError());
            }
        }
    }

    private class StateSimulating
    implements State {
        private StateSimulating() {
        }

        @Override
        public void onTick(long time) {
            if (!this.checkFormat()) {
                ProjectRedFabrication.LOGGER.warn("Loaded simulation from incompatible format. Exiting simulation state.");
                ICEditorStateMachine.this.enterStateAndSend(1);
                return;
            }
            long elapsedTime = ICEditorStateMachine.this.editor.getGameTime() - ICEditorStateMachine.this.lastSimStartTime;
            ICEditorStateMachine.this.simulationContainer.setSystemTime(elapsedTime);
            ICEditorStateMachine.this.simulationContainer.pushTime();
            this.propagateAndNotify();
        }

        @Override
        public void onInputRegistersChanged(int rotation, Function<Short, Short> changeFunction) {
            short oldInput = ICEditorStateMachine.this.simulationContainer.getInput(rotation);
            short newInput = changeFunction.apply(oldInput);
            ProjectRedFabrication.LOGGER.debug("oldInput: " + oldInput + ", newInput: " + newInput);
            if (oldInput != newInput) {
                ICEditorStateMachine.this.simulationContainer.setInput(rotation, newInput);
                ICEditorStateMachine.this.simulationContainer.pushInputs(1 << rotation);
                this.propagateAndNotify();
            }
        }

        private void propagateAndNotify() {
            ICEditorStateMachine.this.simulationContainer.simulate();
            int changeMask = ICEditorStateMachine.this.simulationContainer.pullOutputs();
            if (ICEditorStateMachine.this.callback != null) {
                ICEditorStateMachine.this.callback.onSimulationComplete(changeMask, ICEditorStateMachine.this.simulationContainer);
            }
        }

        private boolean checkFormat() {
            return ICEditorStateMachine.this.lastCompiledFormat == 1;
        }

        @Override
        public void onTileMapChanged() {
            ICEditorStateMachine.this.enterStateAndSend(1);
        }

        @Override
        public boolean canTransitionTo(int id) {
            return id == 1;
        }

        @Override
        public void onStateEntered(int previousStateId) {
            ICEditorStateMachine.this.setLastSimStartTimeAndSend(ICEditorStateMachine.this.editor.getGameTime());
        }
    }

    private class CompileFailed
    implements State {
        private CompileFailed() {
        }

        @Override
        public boolean canTransitionTo(int id) {
            return id == 1;
        }

        @Override
        public void onTileMapChanged() {
            ICEditorStateMachine.this.enterStateAndSend(1);
        }
    }

    public static interface StateMachineCallback {
        public void onCompileStart();

        public void onCompileComplete();

        public void onCompileFailed();

        public void onSimulationComplete(int var1, ICSimulationContainer var2);
    }
}

