/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.inventory.container;

import javax.annotation.Nullable;
import mrtjp.projectred.core.inventory.container.BasePoweredBlockEntityMenu;
import mrtjp.projectred.core.inventory.container.SimpleDataSlot;
import mrtjp.projectred.core.tile.BasePoweredBlockEntity;
import mrtjp.projectred.fabrication.tile.FabricationMachineBlockEntity;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;

public abstract class FabricationMachineMenu
extends BasePoweredBlockEntityMenu {
    private final FabricationMachineBlockEntity tile;
    private int remainingWork;
    private int totalWork;

    public FabricationMachineMenu(@Nullable MenuType<?> containerType, int windowId, FabricationMachineBlockEntity tile) {
        super(containerType, windowId, (BasePoweredBlockEntity)tile);
        this.tile = tile;
        this.addDataSlot((DataSlot)new SimpleDataSlot(tile::getRemainingWork, value -> {
            this.remainingWork = value;
        }));
        this.addDataSlot((DataSlot)new SimpleDataSlot(tile::getTotalWork, value -> {
            this.totalWork = value;
        }));
    }

    public int getProgressScaled(int scale) {
        return this.totalWork == 0 ? 0 : scale * (this.totalWork - this.remainingWork) / this.totalWork;
    }
}

