/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.editor.tools;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.editor.ICEditorToolType;
import mrtjp.projectred.fabrication.editor.tools.BaseICEditorTool;
import mrtjp.projectred.fabrication.editor.tools.IICEditorTool;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EraseTool
extends BaseICEditorTool {
    private final Vector3 initialMouseDown = new Vector3();
    private boolean leftMouseDown;

    @Override
    public ICEditorToolType getToolType() {
        return ICEditorToolType.ERASE_TOOL;
    }

    @Override
    public void readPacket(MCDataInput input) {
        TileCoord start = new TileCoord((int)input.readByte(), (int)input.readByte(), (int)input.readByte());
        TileCoord end = new TileCoord((int)input.readByte(), (int)input.readByte(), (int)input.readByte());
        TileCoord min = start.min(end);
        TileCoord max = start.max(end);
        for (int x = min.x; x <= max.x; ++x) {
            for (int z = min.z; z <= max.z; ++z) {
                TileCoord pos = new TileCoord(x, start.y, z);
                if (!this.getEditor().getTileMap().getBaseTile(pos).isPresent()) continue;
                this.getEditor().removeTile(pos);
            }
        }
    }

    private void executeTool(Vector3 startMouseDown, Vector3 endMouseDown) {
        MCDataOutput out = this.getEditor().getToolStream(this);
        TileCoord start = IICEditorTool.toNearestPosition(startMouseDown);
        TileCoord end = IICEditorTool.toNearestPosition(endMouseDown);
        out.writeByte(start.x).writeByte(start.y).writeByte(start.z);
        out.writeByte(end.x).writeByte(end.y).writeByte(end.z);
    }

    @Override
    public boolean toolStart(Vector3 mousePosition, int glfwMouseButton) {
        if (glfwMouseButton == 0) {
            this.leftMouseDown = true;
            this.initialMouseDown.set(mousePosition);
            return true;
        }
        return false;
    }

    @Override
    public boolean toolReleased(Vector3 mousePosition, int glfwMouseButton) {
        if (glfwMouseButton == 0 && this.leftMouseDown) {
            this.leftMouseDown = false;
            this.executeTool(this.initialMouseDown, mousePosition);
            return true;
        }
        return false;
    }

    @Override
    public void toolLayerChanged(int previousLayer, int newLayer) {
        if (this.leftMouseDown) {
            this.initialMouseDown.y = newLayer;
        }
    }

    @Override
    public boolean toolDragged(Vector3 mousePosition, Vector3 delta, int glfwMouseButton) {
        if (glfwMouseButton == 0) {
            return this.leftMouseDown;
        }
        return false;
    }

    @Override
    public boolean toolScrolled(Vector3 mousePosition, double scroll) {
        return false;
    }

    @Override
    public boolean toolCanceled() {
        if (this.leftMouseDown) {
            this.leftMouseDown = false;
            return true;
        }
        return false;
    }

    @Override
    public void toolActivated() {
        this.leftMouseDown = false;
    }

    @Override
    public void toolDeactivated() {
        this.leftMouseDown = false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(Vector3 mousePosition, boolean isFirstHit, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        if (!isFirstHit) {
            return;
        }
        Vector3 a = this.leftMouseDown ? this.initialMouseDown : mousePosition;
        Vector3 b = mousePosition;
        ccrs.reset();
        ccrs.bind(ICRenderTypes.selectionRenderType, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), matrixStack);
        ccrs.baseColour = EnumColour.PINK.rgba(this.leftMouseDown ? 200 : 32);
        ICRenderTypes.renderSelection(ccrs, a, b, 0.1875, 0.125);
    }
}

