/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mrtjp.projectred.fabrication.init.FabricationDataComponents;
import mrtjp.projectred.fabrication.item.component.ICDataComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public class BlueprintDataComponent
implements TooltipProvider {
    private final CompoundTag editorTag;
    private final ICDataComponent designData;
    public static final Codec<BlueprintDataComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CompoundTag.CODEC.fieldOf("editorTag").forGetter(component -> component.editorTag), (App)ICDataComponent.CODEC.fieldOf("designData").forGetter(component -> component.designData)).apply((Applicative)instance, BlueprintDataComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlueprintDataComponent> STREAM_CODEC = StreamCodec.of((buf, component) -> {
        ByteBufCodecs.COMPOUND_TAG.encode(buf, (Object)component.editorTag);
        ICDataComponent.STREAM_CODEC.encode(buf, (Object)component.designData);
    }, buf -> new BlueprintDataComponent((CompoundTag)ByteBufCodecs.COMPOUND_TAG.decode(buf), (ICDataComponent)ICDataComponent.STREAM_CODEC.decode(buf)));

    public BlueprintDataComponent(CompoundTag editorTag, ICDataComponent designData) {
        this.editorTag = editorTag;
        this.designData = designData;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlueprintDataComponent)) {
            return false;
        }
        BlueprintDataComponent that = (BlueprintDataComponent)o;
        return Objects.equals(this.editorTag, that.editorTag) && Objects.equals(this.designData, that.designData);
    }

    public int hashCode() {
        return Objects.hash(this.editorTag, this.designData);
    }

    public CompoundTag getEditorTag() {
        return this.editorTag.copy();
    }

    public ICDataComponent getICData() {
        return this.designData;
    }

    @Nullable
    public static BlueprintDataComponent getComponent(ItemStack stack) {
        return (BlueprintDataComponent)stack.get(FabricationDataComponents.BLUEPRINT_DATA_COMPONENT_TYPE);
    }

    public static void setComponent(ItemStack stack, BlueprintDataComponent component) {
        stack.set(FabricationDataComponents.BLUEPRINT_DATA_COMPONENT_TYPE, (Object)component);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> component, TooltipFlag flag) {
        this.designData.addToTooltip(context, component, flag);
    }
}

