/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.editor.tools;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.editor.ICEditorToolType;
import mrtjp.projectred.fabrication.editor.tools.BaseICEditorTool;
import mrtjp.projectred.fabrication.editor.tools.IICEditorTool;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.engine.BaseTile;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class InteractTool
extends BaseICEditorTool {
    private static final int KEY_MOUSE_CLICK = 0;
    private static final int KEY_KEY_PRESS = 1;
    private final Vector3 initialMouseDown = new Vector3();
    private boolean leftMouseDown;
    private boolean rightMouseDown;

    @Override
    public ICEditorToolType getToolType() {
        return ICEditorToolType.INTERACT_TOOL;
    }

    @Override
    public void readPacket(MCDataInput input) {
        byte key = input.readByte();
        switch (key) {
            case 0: {
                this.readClickPacket(input);
                break;
            }
            case 1: {
                this.readKeyPressPacket(input);
                break;
            }
            default: {
                ProjectRedFabrication.LOGGER.error("Received invalid packet type for InteractTool: {}", (Object)key);
            }
        }
    }

    private void readClickPacket(MCDataInput input) {
        TileCoord pos = new TileCoord((int)input.readByte(), (int)input.readByte(), (int)input.readByte());
        byte b = input.readByte();
        int z = b & 0x7F;
        boolean leftClick = (b & 0x80) != 0;
        BaseTile tile = this.getEditor().getTileMap().getBaseTile(pos).orElse(null);
        if (tile == null) {
            return;
        }
        InteractionZone zone = tile.getInteractionZones()[z];
        if (leftClick) {
            zone.onLeftClick();
        } else {
            zone.onRightClick();
        }
    }

    private void readKeyPressPacket(MCDataInput input) {
        TileCoord pos = new TileCoord((int)input.readByte(), (int)input.readByte(), (int)input.readByte());
        int glfwKeyCode = input.readInt();
        int glfwFlags = input.readInt();
        BaseTile tile = this.getEditor().getTileMap().getBaseTile(pos).orElse(null);
        if (tile == null) {
            return;
        }
        for (InteractionZone z : tile.getInteractionZones()) {
            z.onKeyPressed(glfwKeyCode, glfwFlags);
        }
    }

    private void sendClick(Vector3 startMouseDown, Vector3 endMouseDown) {
        TileCoord end;
        TileCoord start = IICEditorTool.toNearestPosition(startMouseDown);
        if (!start.equals((Object)(end = IICEditorTool.toNearestPosition(endMouseDown)))) {
            return;
        }
        ZoneIndexPair endZone = this.getMouseoverZone(endMouseDown);
        if (endZone == null) {
            return;
        }
        ZoneIndexPair startZone = this.getMouseoverZone(startMouseDown);
        if (!endZone.equals(startZone)) {
            return;
        }
        byte b = (byte)(endZone.index & 0x7F | (this.leftMouseDown ? 128 : 0));
        this.getEditor().getToolStream(this).writeByte(0).writeByte(start.x).writeByte(start.y).writeByte(start.z).writeByte((int)b);
    }

    private void sendKeyPress(TileCoord pos, int glfwKeyCode, int glfwFlags) {
        this.getEditor().getToolStream(this).writeByte(1).writeByte(pos.x).writeByte(pos.y).writeByte(pos.z).writeInt(glfwKeyCode).writeInt(glfwFlags);
    }

    @Override
    public boolean toolStart(Vector3 mousePosition, int glfwMouseButton) {
        if (glfwMouseButton == 0) {
            this.leftMouseDown = true;
            this.rightMouseDown = false;
            this.initialMouseDown.set(mousePosition);
            return true;
        }
        if (glfwMouseButton == 1) {
            this.rightMouseDown = true;
            this.leftMouseDown = false;
            this.initialMouseDown.set(mousePosition);
            return true;
        }
        return false;
    }

    @Override
    public boolean toolReleased(Vector3 mousePosition, int glfwMouseButton) {
        if (glfwMouseButton == 0 && this.leftMouseDown || glfwMouseButton == 1 && this.rightMouseDown) {
            this.sendClick(this.initialMouseDown, mousePosition);
            this.leftMouseDown = false;
            this.rightMouseDown = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean toolDragged(Vector3 mousePosition, Vector3 delta, int glfwMouseButton) {
        if (glfwMouseButton == 0) {
            return this.leftMouseDown;
        }
        if (glfwMouseButton == 1) {
            return this.rightMouseDown;
        }
        return false;
    }

    @Override
    public boolean toolScrolled(Vector3 mousePosition, double scroll) {
        return false;
    }

    @Override
    public void toolLayerChanged(int previousLayer, int newLayer) {
        if (this.leftMouseDown) {
            this.initialMouseDown.y = newLayer;
        }
    }

    @Override
    public boolean toolCanceled() {
        if (this.leftMouseDown) {
            this.leftMouseDown = false;
            return true;
        }
        return false;
    }

    @Override
    public void toolActivated() {
        this.leftMouseDown = false;
    }

    @Override
    public void toolDeactivated() {
        this.leftMouseDown = false;
    }

    @Override
    public boolean toolKeyPressed(Vector3 mousePosition, int glfwKeyCode, int glfwFlags) {
        TileCoord coord = IICEditorTool.toNearestPosition(mousePosition);
        BaseTile tile = this.getEditor().getTileMap().getBaseTile(coord).orElse(null);
        if (tile == null) {
            return false;
        }
        if (FastStream.of((Object[])tile.getInteractionZones()).anyMatch(z -> z.canRespondToKey(glfwKeyCode, glfwFlags))) {
            this.sendKeyPress(coord, glfwKeyCode, glfwFlags);
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void buildTooltip(Vector3 mousePosition, boolean isFirstHit, List<Component> tooltip) {
        super.buildTooltip(mousePosition, isFirstHit, tooltip);
        if (!isFirstHit) {
            return;
        }
        ZoneIndexPair zone = this.getMouseoverZone(mousePosition);
        if (zone == null) {
            return;
        }
        zone.zone.buildToolTip(tooltip);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(Vector3 mousePosition, boolean isFirstHit, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        if (!isFirstHit) {
            return;
        }
        Vector3 a = this.leftMouseDown || this.rightMouseDown ? this.initialMouseDown : mousePosition;
        Vector3 b = mousePosition;
        TileCoord coord = IICEditorTool.toNearestPosition(a);
        this.getEditor().getTileMap().getBaseTile(coord).ifPresent(tile -> {
            InteractionZone[] zones2 = tile.getInteractionZones();
            if (zones2.length == 0) {
                return;
            }
            matrixStack.pushPose();
            matrixStack.translate((float)coord.x, (float)coord.y, (float)coord.z);
            for (InteractionZone zone : zones2) {
                Cuboid6 box = IICEditorTool.internalToGlobalCuboid(coord, zone.getBounds());
                boolean isSelected = (this.leftMouseDown || this.rightMouseDown) && box.contains(a);
                boolean IsMouseover = box.contains(b);
                zone.renderZone(ccrs, getter, matrixStack, isSelected, IsMouseover);
            }
            matrixStack.popPose();
        });
    }

    private TileCoord getTargetTileCoord(Vector3 mousePosition) {
        return IICEditorTool.toNearestPosition(this.leftMouseDown || this.rightMouseDown ? this.initialMouseDown : mousePosition);
    }

    @Nullable
    private ZoneIndexPair getMouseoverZone(Vector3 mousePosition) {
        TileCoord coord = this.getTargetTileCoord(mousePosition);
        BaseTile tile = this.getEditor().getTileMap().getBaseTile(coord).orElse(null);
        if (tile == null) {
            return null;
        }
        Vector3 localMousePos = mousePosition.copy().subtract((double)coord.x, (double)coord.y, (double)coord.z);
        InteractionZone[] zones = tile.getInteractionZones();
        for (int i = 0; i < zones.length; ++i) {
            InteractionZone zone = zones[i];
            if (!zone.getBounds().contains(localMousePos)) continue;
            return new ZoneIndexPair(zone, i);
        }
        return null;
    }

    private record ZoneIndexPair(InteractionZone zone, int index) {
    }
}

