/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.engine.log.CompileProblem;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchCompileTab;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUISprite;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ProblemListNode
extends AbstractGuiNode {
    private final List<CompileProblem> problemList = new LinkedList<CompileProblem>();
    private final AbstractGuiNode listParent = new AbstractGuiNode(this){};
    private double scroll = 0.0;

    public ProblemListNode() {
        this.initSubNodes();
    }

    private void initSubNodes() {
        this.addChild((RedUINode)this.listParent);
    }

    public void setProblemList(List<CompileProblem> list) {
        this.problemList.clear();
        this.problemList.addAll(list);
        this.refreshListItems();
    }

    private void refreshListItems() {
        this.listParent.removeAllChildren();
        this.listParent.setPosition(0, 0);
        int y = 0;
        for (CompileProblem issue : this.problemList) {
            IssueListItemNode item = new IssueListItemNode(issue);
            item.setPosition(0, y);
            this.listParent.addChild((RedUINode)item);
            y += item.calculateAccumulatedFrame().height();
        }
        this.moveListToScroll();
    }

    public void setScrollPercentage(double scrollPercentage) {
        this.scroll = scrollPercentage;
        this.moveListToScroll();
    }

    private void moveListToScroll() {
        Rect subFrame = this.calculateChildrenFrame();
        if (subFrame.height() <= this.getFrame().height()) {
            return;
        }
        int totalScroll = subFrame.height() - this.getFrame().height();
        int dist = (int)((double)totalScroll * this.scroll);
        this.listParent.setPosition(0, -dist);
    }

    public void onSubTreePreDrawBack() {
        Rect gl11Rect = this.calculateGL11Frame();
        RenderSystem.enableScissor((int)gl11Rect.x(), (int)gl11Rect.y(), (int)gl11Rect.width(), (int)gl11Rect.height());
    }

    public void onSubTreePostDrawBack() {
        RenderSystem.disableScissor();
    }

    private class IssueListItemNode
    extends AbstractGuiNode {
        private static final RedUISprite BACKGROUND_UNSELECTED = new RedUISprite(ICWorkbenchCompileTab.TAB_BACKGROUND, 1, 375, 79, 12, 512, 512);
        private final CompileProblem issue;

        public IssueListItemNode(CompileProblem issue) {
            this.issue = issue;
            this.setSize(79, 12);
        }

        public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
            this.blitSprite(graphics, BACKGROUND_UNSELECTED);
            Font fr = this.getRoot().getFontRenderer();
            MutableComponent c = this.issue.getName().copy().withStyle(ICWorkbenchEditor.UNIFORM);
            int n = this.getFrame().x() + 2;
            int n2 = this.getFrame().y() + this.getFrame().height() / 2;
            Objects.requireNonNull(fr);
            graphics.drawString(fr, (Component)c, n, n2 - 9 / 2, 0xFFFFFF, false);
        }

        public void drawFront(GuiGraphics graphics, Point mouse, float partialFrame) {
            if (!this.isFirstHit(mouse)) {
                return;
            }
            LinkedList<Component> toolTip = new LinkedList<Component>();
            toolTip.add(this.issue.getName());
            this.issue.buildToolTip(toolTip);
            this.renderTooltip(graphics, mouse, toolTip);
        }

        public boolean checkHit(Point absPoint) {
            return super.checkHit(absPoint) && ProblemListNode.this.convertParentRectToScreen(ProblemListNode.this.getFrame()).contains(absPoint);
        }
    }
}

