/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.inventory.container;

import codechicken.lib.inventory.container.CCLMenuType;
import mrtjp.projectred.core.inventory.container.TakeOnlySlot;
import mrtjp.projectred.fabrication.init.FabricationMenus;
import mrtjp.projectred.fabrication.inventory.container.FabricationMachineMenu;
import mrtjp.projectred.fabrication.item.PhotomaskSetItem;
import mrtjp.projectred.fabrication.item.RoughSiliconWaferItem;
import mrtjp.projectred.fabrication.tile.LithographyTableBlockEntity;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LithographyTableMenu
extends FabricationMachineMenu {
    public static CCLMenuType<LithographyTableMenu> FACTORY = (windowId, inventory, packet) -> {
        BlockEntity tile = inventory.player.level().getBlockEntity(packet.readPos());
        if (!(tile instanceof LithographyTableBlockEntity)) {
            return null;
        }
        return new LithographyTableMenu(inventory, (LithographyTableBlockEntity)tile, windowId);
    };
    private final Inventory playerInventory;
    private final LithographyTableBlockEntity tile;

    public LithographyTableMenu(Inventory playerInventory, LithographyTableBlockEntity tile, int windowId) {
        super(FabricationMenus.LITHOGRAPHY_TABLE_MENU.get(), windowId, tile);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)playerInventory, (int)8, (int)89, arg_0 -> ((LithographyTableMenu)this).addSlot(arg_0));
        this.addLithographyTableInventory();
    }

    private void addLithographyTableInventory() {
        this.addSlot(new Slot(this.tile.getInventory(), 0, 56, 31));
        this.addSlot(new Slot(this.tile.getInventory(), 1, 56, 49));
        this.addSlot((Slot)new TakeOnlySlot(this.tile.getInventory(), 2, 110, 31));
        this.addSlot((Slot)new TakeOnlySlot(this.tile.getInventory(), 3, 110, 49));
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (this.isOutputs(slotIndex) ? !this.moveToEntireInventory(stack, true) : (this.isHotbar(slotIndex) || this.isPlayerInventory(slotIndex) ? (this.isPhotomaskSet(stack) ? !this.moveToPhotomaskInput(stack, false) : (this.isSiliconWafer(stack) ? !this.moveToWaferInput(stack, false) : (this.isPlayerInventory(slotIndex) ? !this.moveToHotbar(stack, false) : !this.moveToPlayerInventory(stack, false)))) : this.isInputs(slotIndex) && !this.moveToEntireInventory(stack, true))) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == originalStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return originalStack;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isInputs(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 38;
    }

    private boolean isOutputs(int slotIndex) {
        return slotIndex >= 38 && slotIndex < 40;
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 27, 36, reverse);
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 27, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 36, reverse);
    }

    private boolean moveToPhotomaskInput(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 36, 37, reverse);
    }

    private boolean moveToWaferInput(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 37, 38, reverse);
    }

    private boolean isPhotomaskSet(ItemStack stack) {
        return stack.getItem() instanceof PhotomaskSetItem;
    }

    private boolean isSiliconWafer(ItemStack stack) {
        return stack.getItem() instanceof RoughSiliconWaferItem;
    }
}

