/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.gui.buttons;

import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;

public class PlaySoundButton
extends AbstractButton {
    private static boolean isFromPSB = false;
    private SoundInstance buttonSound;

    PlaySoundButton(int x, int y, SoundEvent sound) {
        super(x, y, 10, 10, CommonComponents.EMPTY);
        this.setAlpha(0.0f);
        this.buttonSound = SimpleSoundInstance.forUI((SoundEvent)sound, (float)1.0f);
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent mouseButtonEvent, boolean success) {
        return this.isMouseOver(mouseButtonEvent.x(), mouseButtonEvent.y()) && super.mouseClicked(mouseButtonEvent, success);
    }

    public void onPress(@NotNull InputWithModifiers inputWithModifiers) {
        isFromPSB = false;
    }

    public void playDownSound(SoundManager soundHandler) {
        isFromPSB = true;
        if (!soundHandler.isActive(this.buttonSound)) {
            soundHandler.play(this.buttonSound);
        } else {
            soundHandler.stop(this.buttonSound);
        }
    }

    public static boolean isFromPSB() {
        return isFromPSB;
    }

    public void updateWidgetNarration(NarrationElementOutput elementOutput) {
        elementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
    }
}

