/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.mixins;

import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.gui.buttons.InvButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.CraftingRecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin
extends AbstractRecipeBookScreen<InventoryMenu> {
    @Unique
    private InvButton esm_invButton = new InvButton(this.esm_getIBX(), this.esm_getIBY());

    public InventoryScreenMixin(Player player) {
        super((RecipeBookMenu)player.inventoryMenu, (RecipeBookComponent)new CraftingRecipeBookComponent((AbstractCraftingMenu)player.inventoryMenu), player.getInventory(), (Component)Component.translatable((String)"container.crafting"));
    }

    @Inject(method={"Lnet/minecraft/client/gui/screens/inventory/InventoryScreen;init()V"}, at={@At(value="HEAD")})
    private void esm_inventoryScreenInit(CallbackInfo CI) {
        if (!CommonConfig.get().disableInventoryButton().get().booleanValue()) {
            this.addRenderableWidget((GuiEventListener)this.esm_invButton);
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void esm_inventoryScreenRender(GuiGraphics render, int mouseX, int mouseY, float tick, CallbackInfo ci) {
        if (this.esm_invButton.hold) {
            this.esm_invButton.setX(mouseX - 6);
            this.esm_invButton.setY(mouseY - 6);
        } else {
            this.esm_invButton.setX(this.esm_getIBX());
            this.esm_invButton.setY(this.esm_getIBY());
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")})
    private void esm_onMouseReleased(MouseButtonEvent mouseButtonEvent, CallbackInfoReturnable cir) {
        if (this.esm_invButton.hold && mouseButtonEvent.button() == 1) {
            this.esm_invButton.setX(this.esm_invButton.getX() - this.leftPos);
            this.esm_invButton.setY(this.esm_invButton.getY() - this.topPos);
            this.esm_invButton.hold = false;
        }
    }

    @Unique
    private int esm_getIBX() {
        return this.leftPos + CommonConfig.get().invButtonHorizontal().get();
    }

    @Unique
    private int esm_getIBY() {
        return this.topPos + CommonConfig.get().invButtonVertical().get();
    }
}

