/*
 * Decompiled with CFR 0.152.
 */
package Strikeboom.cobblestonesemantics.guis.blockentities;

import Strikeboom.cobblestonesemantics.guis.blockentities.fluidtanks.CobblestoneMelterFluidTank;
import Strikeboom.cobblestonesemantics.guis.blockentities.itemhandlers.CobblestoneMelterItemHandler;
import Strikeboom.cobblestonesemantics.init.CobblestoneSemanticsBlockEntities;
import Strikeboom.cobblestonesemantics.init.CobblestoneSemanticsConfig;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CobblestoneMelterBlockEntity
extends BlockEntity {
    ItemStackHandler itemStackHandler = new CobblestoneMelterItemHandler(1){

        protected void onContentsChanged(int slot) {
            CobblestoneMelterBlockEntity.this.m_6596_();
            CobblestoneMelterBlockEntity.this.f_58857_.m_7260_(CobblestoneMelterBlockEntity.this.f_58858_, CobblestoneMelterBlockEntity.this.m_58900_(), CobblestoneMelterBlockEntity.this.m_58900_(), 3);
        }
    };
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional;
    FluidTank fluidTank = new CobblestoneMelterFluidTank(10000){

        protected void onContentsChanged() {
            CobblestoneMelterBlockEntity.this.m_6596_();
            CobblestoneMelterBlockEntity.this.f_58857_.m_7260_(CobblestoneMelterBlockEntity.this.f_58858_, CobblestoneMelterBlockEntity.this.m_58900_(), CobblestoneMelterBlockEntity.this.m_58900_(), 3);
        }
    };
    private final LazyOptional<IFluidHandler> fluidHandlerLazyOptional;
    int cooldown = 0;
    int delay;

    public CobblestoneMelterBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CobblestoneSemanticsBlockEntities.COBBLESTONE_MELTER_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
        this.itemHandlerLazyOptional = LazyOptional.of(() -> this.itemStackHandler);
        this.fluidHandlerLazyOptional = LazyOptional.of(() -> this.fluidTank);
        this.delay = (Integer)CobblestoneSemanticsConfig.COBBLESTONE_MELTER_DELAY.get();
    }

    public void m_7651_() {
        super.m_7651_();
        this.itemHandlerLazyOptional.invalidate();
        this.fluidHandlerLazyOptional.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT());
        this.fluidTank.writeToNBT(pTag);
        CompoundTag infoTag = new CompoundTag();
        infoTag.m_128405_("Cooldown", this.cooldown);
        infoTag.m_128405_("DelayUntilNextCobbleStone", this.delay);
        pTag.m_128365_("Info", (Tag)infoTag);
    }

    public void m_142466_(CompoundTag pTag) {
        if (pTag.m_128441_("ItemStackHandler")) {
            this.itemStackHandler.deserializeNBT(pTag.m_128469_("ItemStackHandler"));
        }
        this.fluidTank.readFromNBT(pTag);
        if (pTag.m_128441_("Info")) {
            this.cooldown = pTag.m_128469_("Info").m_128451_("Cooldown");
            this.delay = pTag.m_128469_("Info").m_128451_("DelayUntilNextCobbleStone");
        }
        super.m_142466_(pTag);
    }

    public void tickServer() {
        this.delay = (Integer)CobblestoneSemanticsConfig.COBBLESTONE_MELTER_DELAY.get();
        boolean shouldUpdate = false;
        if (this.fluidTank.getFluid().getAmount() + (Integer)CobblestoneSemanticsConfig.COBBLESTONE_MELTER_LAVA_PER_COBBLESTONE.get() <= this.fluidTank.getCapacity() && !this.itemStackHandler.getStackInSlot(0).m_41619_()) {
            ++this.cooldown;
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)));
            shouldUpdate = true;
        } else if (this.cooldown != 0) {
            this.cooldown = 0;
            if (this.itemStackHandler.getStackInSlot(0).m_41619_()) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
            }
            shouldUpdate = true;
        }
        if (this.cooldown % this.delay == 0 && this.cooldown != 0) {
            this.cooldown = 0;
            if (!this.fluidTank.getFluid().isEmpty()) {
                this.fluidTank.getFluid().grow(((Integer)CobblestoneSemanticsConfig.COBBLESTONE_MELTER_LAVA_PER_COBBLESTONE.get()).intValue());
            } else {
                this.fluidTank.setFluid(new FluidStack((Fluid)Fluids.f_76195_, ((Integer)CobblestoneSemanticsConfig.COBBLESTONE_MELTER_LAVA_PER_COBBLESTONE.get()).intValue()));
            }
            this.itemStackHandler.getStackInSlot(0).m_41774_(1);
            if (this.itemStackHandler.getStackInSlot(0).m_41619_()) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
            }
        }
        if (shouldUpdate) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerLazyOptional.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getDelay() {
        return this.delay;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        int oldCooldown = this.cooldown;
        int oldDelay = this.delay;
        ItemStackHandler oldItemStackHandler = this.itemStackHandler;
        FluidTank oldFluidTank = this.fluidTank;
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
        if (oldCooldown != this.cooldown || oldDelay != this.delay || !Objects.equals(oldItemStackHandler, this.itemStackHandler) || !Objects.equals(oldFluidTank, this.fluidTank)) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }
}

