/*
 * Decompiled with CFR 0.152.
 */
package Strikeboom.cobblestonesemantics.blocks;

import Strikeboom.cobblestonesemantics.guis.tileentities.CobblestoneGeneratorTileEntity;
import Strikeboom.cobblestonesemantics.guis.tileentities.itemhandlers.CobblestoneGeneratorItemHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class CobblestoneGenerator
extends Block {
    int tier;
    int storageSlots;
    int delayUntilNextCobbleStone;
    int amountOfCobblestoneEachOperation;

    public CobblestoneGenerator(int tier, int storageSlots, int delayUntilNextCobbleStone, int amountOfCobblestoneEachOperation) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151667_k).func_200947_a(SoundType.field_185852_e).func_200948_a(8.0f, 250.0f).func_235861_h_());
        this.tier = tier;
        this.storageSlots = storageSlots;
        this.delayUntilNextCobbleStone = delayUntilNextCobbleStone;
        this.amountOfCobblestoneEachOperation = amountOfCobblestoneEachOperation;
    }

    public void func_190948_a(ItemStack pStack, @Nullable IBlockReader pWorld, List<ITextComponent> pTooltip, ITooltipFlag pFlag) {
        if (pStack.func_77942_o() && pStack.func_77978_p().func_74764_b("ItemStackHandler")) {
            pTooltip.add((ITextComponent)new TranslationTextComponent("block.cobblestonesemantics.tooltip.saved").func_240699_a_(TextFormatting.GREEN));
        }
        pTooltip.add((ITextComponent)new TranslationTextComponent("block.cobblestonesemantics.tooltip.crouch").func_240699_a_(TextFormatting.YELLOW));
        pTooltip.add((ITextComponent)new TranslationTextComponent("block.cobblestonesemantics.tooltip.outputs").func_240699_a_(TextFormatting.YELLOW));
        pTooltip.add((ITextComponent)new TranslationTextComponent("block.cobblestonesemantics.tooltip.tier", new Object[]{Integer.toString(this.tier)}));
        pTooltip.add((ITextComponent)new TranslationTextComponent("block.cobblestonesemantics.tooltip.storage", new Object[]{Integer.toString(this.storageSlots * 64)}));
        pTooltip.add((ITextComponent)new TranslationTextComponent("block.cobblestonesemantics.tooltip.delay", new Object[]{Integer.toString(this.delayUntilNextCobbleStone)}));
        pTooltip.add((ITextComponent)new TranslationTextComponent("block.cobblestonesemantics.tooltip.amount", new Object[]{Integer.toString(this.amountOfCobblestoneEachOperation)}));
    }

    public int getTier() {
        return this.tier;
    }

    public int getAmountOfCobblestoneEachOperation() {
        return this.amountOfCobblestoneEachOperation;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CobblestoneGeneratorTileEntity(this.storageSlots, this.delayUntilNextCobbleStone, this.amountOfCobblestoneEachOperation);
    }

    public ActionResultType func_225533_a_(BlockState pState, World pWorld, BlockPos pPos, PlayerEntity pPlayer, Hand pHand, BlockRayTraceResult pHit) {
        if (!pWorld.field_72995_K && pWorld.func_175625_s(pPos) instanceof CobblestoneGeneratorTileEntity) {
            if (!pPlayer.func_213453_ef()) {
                CobblestoneGeneratorTileEntity be = (CobblestoneGeneratorTileEntity)pWorld.func_175625_s(pPos);
                be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
                    ItemStack stack = ((CobblestoneGeneratorItemHandler)((Object)iItemHandler)).getLargestSlotThenRemove();
                    if (!stack.func_190926_b() && !pPlayer.field_71071_by.func_70441_a(stack)) {
                        InventoryHelper.func_180173_a((World)pWorld, (double)pPos.func_177958_n(), (double)pPos.func_177956_o(), (double)pPos.func_177952_p(), (ItemStack)stack);
                    }
                });
            } else {
                pPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("block.cobblestonesemantics.message.amount", new Object[]{((CobblestoneGeneratorTileEntity)pWorld.func_175625_s(pPos)).getCobblestoneAmount()}), Util.field_240973_b_);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180657_a(World pWorld, PlayerEntity pPlayer, BlockPos pPos, BlockState pState, @Nullable TileEntity pBlockEntity, ItemStack pTool) {
        if (!pWorld.field_72995_K) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            if (pBlockEntity != null) {
                CompoundNBT nbt = new CompoundNBT();
                pBlockEntity.func_189515_b(nbt);
                stack.func_77982_d(nbt);
            }
            InventoryHelper.func_180173_a((World)pWorld, (double)pPos.func_177958_n(), (double)pPos.func_177956_o(), (double)pPos.func_177952_p(), (ItemStack)stack);
        }
    }

    public void func_180633_a(World pWorld, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (!pWorld.field_72995_K && pStack.func_77942_o()) {
            pStack.func_77978_p().func_74768_a("x", pPos.func_177958_n());
            pStack.func_77978_p().func_74768_a("y", pPos.func_177956_o());
            pStack.func_77978_p().func_74768_a("z", pPos.func_177952_p());
            pWorld.func_175625_s(pPos).func_230337_a_(pState, pStack.func_77978_p());
        }
    }
}

