/*
 * Decompiled with CFR 0.152.
 */
package Strikeboom.cobblestonesemantics.guis.tileentities;

import Strikeboom.cobblestonesemantics.guis.tileentities.energystorage.CobblestoneSemanticsEnergyStorage;
import Strikeboom.cobblestonesemantics.guis.tileentities.itemhandlers.AllInOneGeneratorItemHandler;
import Strikeboom.cobblestonesemantics.init.CobblestoneSemanticsConfig;
import Strikeboom.cobblestonesemantics.init.CobblestoneSemanticsTileEntities;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class AllInOneGeneratorTileEntity
extends TileEntity
implements ITickableTileEntity {
    private final AllInOneGeneratorItemHandler itemStackHandler = new AllInOneGeneratorItemHandler(){

        protected void onContentsChanged(int slot) {
            AllInOneGeneratorTileEntity.this.func_70296_d();
            AllInOneGeneratorTileEntity.this.field_145850_b.func_184138_a(AllInOneGeneratorTileEntity.this.field_174879_c, AllInOneGeneratorTileEntity.this.func_195044_w(), AllInOneGeneratorTileEntity.this.func_195044_w(), 3);
        }
    };
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemStackHandler);
    private final CobblestoneSemanticsEnergyStorage energyStorage = new CobblestoneSemanticsEnergyStorage(10000000, false, true){

        @Override
        protected void onEnergyChanged() {
            if (AllInOneGeneratorTileEntity.this.field_145850_b != null) {
                AllInOneGeneratorTileEntity.this.func_70296_d();
                AllInOneGeneratorTileEntity.this.field_145850_b.func_184138_a(AllInOneGeneratorTileEntity.this.field_174879_c, AllInOneGeneratorTileEntity.this.func_195044_w(), AllInOneGeneratorTileEntity.this.func_195044_w(), 3);
            }
        }
    };
    private final LazyOptional<IEnergyStorage> energyLazyOptional = LazyOptional.of(() -> this.energyStorage);
    private int cooldown = 0;
    private int delay = 100;

    public AllInOneGeneratorTileEntity() {
        super((TileEntityType)CobblestoneSemanticsTileEntities.ALL_IN_ONE_GENERATOR_BLOCK_ENTITY.get());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.itemHandlerLazyOptional.invalidate();
        this.energyLazyOptional.invalidate();
    }

    public CompoundNBT func_189515_b(CompoundNBT pTag) {
        pTag.func_74768_a("energy", this.energyStorage.getEnergyStored());
        pTag.func_218657_a("ItemStackHandler", (INBT)this.itemStackHandler.serializeNBT());
        CompoundNBT infoTag = new CompoundNBT();
        infoTag.func_74768_a("Cooldown", this.cooldown);
        infoTag.func_74768_a("Delay", this.delay);
        pTag.func_218657_a("Info", (INBT)infoTag);
        return super.func_189515_b(pTag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT pTag) {
        if (pTag.func_74764_b("ItemStackHandler")) {
            this.itemStackHandler.deserializeNBT(pTag.func_74775_l("ItemStackHandler"));
        }
        if (pTag.func_74764_b("energy")) {
            this.energyStorage.setEnergy(pTag.func_74762_e("energy"));
        }
        if (pTag.func_74764_b("Info")) {
            this.cooldown = pTag.func_74775_l("Info").func_74762_e("Cooldown");
            this.delay = pTag.func_74775_l("Info").func_74762_e("Delay");
        }
        super.func_230337_a_(state, pTag);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean shouldUpdate = false;
            int energyProduced = (Integer)CobblestoneSemanticsConfig.LAVA_GENERATOR_POWER_PER_LAVA_BUCKET.get() * (int)(Math.floor((float)this.itemStackHandler.getLavaGenerators() / 2.0f) < (double)this.itemStackHandler.getLavaMelters() ? Math.floor((float)this.itemStackHandler.getLavaGenerators() / 2.0f) : (double)this.itemStackHandler.getLavaMelters());
            if (!this.itemStackHandler.getStackInSlot(0).func_190926_b() && this.itemStackHandler.getLavaGenerators() > 0 && this.itemStackHandler.getLavaMelters() > 0 && energyProduced != 0 && this.energyStorage.getEnergyStored() + energyProduced <= this.energyStorage.getMaxEnergyStored()) {
                this.cooldown += this.itemStackHandler.getCobbleGenTier();
                if (this.cooldown > this.delay) {
                    this.cooldown = this.delay;
                }
                shouldUpdate = true;
            } else if (this.cooldown != 0) {
                this.cooldown = 0;
                shouldUpdate = true;
            }
            if (this.cooldown % this.delay == 0 && this.cooldown != 0) {
                this.cooldown = 0;
                this.energyStorage.addEnergy(energyProduced);
            }
            if (shouldUpdate) {
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerLazyOptional.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        this.func_189515_b(tag);
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        if (tag != null) {
            this.func_230337_a_(state, tag);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        int oldCooldown = this.cooldown;
        int oldDelay = this.delay;
        CobblestoneSemanticsEnergyStorage oldEnergyStorage = this.energyStorage;
        AllInOneGeneratorItemHandler oldItemStackHandler = this.itemStackHandler;
        CompoundNBT tag = pkt.func_148857_g();
        this.handleUpdateTag(null, tag);
        if (oldCooldown != this.cooldown || oldDelay != this.delay || !Objects.equals((Object)oldEnergyStorage, (Object)this.energyStorage) || !Objects.equals((Object)oldItemStackHandler, (Object)this.itemStackHandler)) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getDelay() {
        return this.delay;
    }
}

