/*
 * Decompiled with CFR 0.152.
 */
package Strikeboom.cobblestonesemantics.guis.tileentities;

import Strikeboom.cobblestonesemantics.guis.tileentities.fluidtanks.CobblestoneMelterFluidTank;
import Strikeboom.cobblestonesemantics.guis.tileentities.itemhandlers.CobblestoneMelterItemHandler;
import Strikeboom.cobblestonesemantics.init.CobblestoneSemanticsConfig;
import Strikeboom.cobblestonesemantics.init.CobblestoneSemanticsTileEntities;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CobblestoneMelterTileEntity
extends TileEntity
implements ITickableTileEntity {
    ItemStackHandler itemStackHandler = new CobblestoneMelterItemHandler(1){

        protected void onContentsChanged(int slot) {
            CobblestoneMelterTileEntity.this.func_70296_d();
            CobblestoneMelterTileEntity.this.field_145850_b.func_184138_a(CobblestoneMelterTileEntity.this.field_174879_c, CobblestoneMelterTileEntity.this.func_195044_w(), CobblestoneMelterTileEntity.this.func_195044_w(), 3);
        }
    };
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional;
    FluidTank fluidTank = new CobblestoneMelterFluidTank(10000){

        protected void onContentsChanged() {
            CobblestoneMelterTileEntity.this.func_70296_d();
            CobblestoneMelterTileEntity.this.field_145850_b.func_184138_a(CobblestoneMelterTileEntity.this.field_174879_c, CobblestoneMelterTileEntity.this.func_195044_w(), CobblestoneMelterTileEntity.this.func_195044_w(), 3);
        }
    };
    private final LazyOptional<IFluidHandler> fluidHandlerLazyOptional;
    int cooldown = 0;
    int delay;

    public CobblestoneMelterTileEntity() {
        super((TileEntityType)CobblestoneSemanticsTileEntities.COBBLESTONE_MELTER_BLOCK_ENTITY.get());
        this.itemHandlerLazyOptional = LazyOptional.of(() -> this.itemStackHandler);
        this.fluidHandlerLazyOptional = LazyOptional.of(() -> this.fluidTank);
        this.delay = (Integer)CobblestoneSemanticsConfig.COBBLESTONE_MELTER_DELAY.get();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.itemHandlerLazyOptional.invalidate();
        this.fluidHandlerLazyOptional.invalidate();
    }

    public CompoundNBT func_189515_b(CompoundNBT pTag) {
        pTag.func_218657_a("ItemStackHandler", (INBT)this.itemStackHandler.serializeNBT());
        this.fluidTank.writeToNBT(pTag);
        CompoundNBT infoTag = new CompoundNBT();
        infoTag.func_74768_a("Cooldown", this.cooldown);
        infoTag.func_74768_a("DelayUntilNextCobbleStone", this.delay);
        pTag.func_218657_a("Info", (INBT)infoTag);
        return super.func_189515_b(pTag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT pTag) {
        if (pTag.func_74764_b("ItemStackHandler")) {
            this.itemStackHandler.deserializeNBT(pTag.func_74775_l("ItemStackHandler"));
        }
        this.fluidTank.readFromNBT(pTag);
        if (pTag.func_74764_b("Info")) {
            this.cooldown = pTag.func_74775_l("Info").func_74762_e("Cooldown");
            this.delay = pTag.func_74775_l("Info").func_74762_e("DelayUntilNextCobbleStone");
        }
        super.func_230337_a_(state, pTag);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.delay = (Integer)CobblestoneSemanticsConfig.COBBLESTONE_MELTER_DELAY.get();
            boolean shouldUpdate = false;
            if (this.fluidTank.getFluid().getAmount() + (Integer)CobblestoneSemanticsConfig.COBBLESTONE_MELTER_LAVA_PER_COBBLESTONE.get() <= this.fluidTank.getCapacity() && !this.itemStackHandler.getStackInSlot(0).func_190926_b()) {
                ++this.cooldown;
                this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)));
                shouldUpdate = true;
            } else if (this.cooldown != 0) {
                this.cooldown = 0;
                if (this.itemStackHandler.getStackInSlot(0).func_190926_b()) {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
                }
                shouldUpdate = true;
            }
            if (this.cooldown % this.delay == 0 && this.cooldown != 0) {
                this.cooldown = 0;
                if (!this.fluidTank.getFluid().isEmpty()) {
                    this.fluidTank.getFluid().grow(((Integer)CobblestoneSemanticsConfig.COBBLESTONE_MELTER_LAVA_PER_COBBLESTONE.get()).intValue());
                } else {
                    this.fluidTank.setFluid(new FluidStack((Fluid)Fluids.field_204547_b, ((Integer)CobblestoneSemanticsConfig.COBBLESTONE_MELTER_LAVA_PER_COBBLESTONE.get()).intValue()));
                }
                this.itemStackHandler.getStackInSlot(0).func_190918_g(1);
                if (this.itemStackHandler.getStackInSlot(0).func_190926_b() || this.fluidTank.getFluid().getAmount() >= this.fluidTank.getCapacity()) {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
                }
            }
            if (shouldUpdate) {
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerLazyOptional.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getDelay() {
        return this.delay;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        this.func_189515_b(tag);
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        if (tag != null) {
            this.func_230337_a_(state, tag);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        int oldCooldown = this.cooldown;
        int oldDelay = this.delay;
        ItemStackHandler oldItemStackHandler = this.itemStackHandler;
        FluidTank oldFluidTank = this.fluidTank;
        CompoundNBT tag = pkt.func_148857_g();
        this.handleUpdateTag(null, tag);
        if (oldCooldown != this.cooldown || oldDelay != this.delay || !Objects.equals(oldItemStackHandler, this.itemStackHandler) || !Objects.equals(oldFluidTank, this.fluidTank)) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }
}

