/*
 * Decompiled with CFR 0.152.
 */
package Strikeboom.cobblestonesemantics.guis.tileentities;

import Strikeboom.cobblestonesemantics.guis.tileentities.energystorage.CobblestoneSemanticsEnergyStorage;
import Strikeboom.cobblestonesemantics.guis.tileentities.fluidtanks.LavaGeneratorFluidTank;
import Strikeboom.cobblestonesemantics.init.CobblestoneSemanticsConfig;
import Strikeboom.cobblestonesemantics.init.CobblestoneSemanticsTileEntities;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class LavaGeneratorTileEntity
extends TileEntity
implements ITickableTileEntity {
    private final FluidTank fluidTank = new LavaGeneratorFluidTank(5000){

        protected void onContentsChanged() {
            LavaGeneratorTileEntity.this.func_70296_d();
            LavaGeneratorTileEntity.this.field_145850_b.func_184138_a(LavaGeneratorTileEntity.this.field_174879_c, LavaGeneratorTileEntity.this.func_195044_w(), LavaGeneratorTileEntity.this.func_195044_w(), 3);
        }
    };
    private final LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> this.fluidTank);
    private final CobblestoneSemanticsEnergyStorage energyStorage = new CobblestoneSemanticsEnergyStorage(1000000, false, true){

        @Override
        protected void onEnergyChanged() {
            if (LavaGeneratorTileEntity.this.field_145850_b != null) {
                LavaGeneratorTileEntity.this.func_70296_d();
                LavaGeneratorTileEntity.this.field_145850_b.func_184138_a(LavaGeneratorTileEntity.this.field_174879_c, LavaGeneratorTileEntity.this.func_195044_w(), LavaGeneratorTileEntity.this.func_195044_w(), 3);
            }
        }
    };
    private final LazyOptional<IEnergyStorage> energyLazyOptional = LazyOptional.of(() -> this.energyStorage);
    private int cooldown = 0;
    private int delay = (Integer)CobblestoneSemanticsConfig.LAVA_GENERATOR_DELAY.get();

    public LavaGeneratorTileEntity() {
        super((TileEntityType)CobblestoneSemanticsTileEntities.LAVA_GENERATOR_BLOCK_ENTITY.get());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.energyLazyOptional.invalidate();
        this.fluidHandlerLazyOptional.invalidate();
    }

    public CompoundNBT func_189515_b(CompoundNBT pTag) {
        pTag.func_74768_a("energy", this.energyStorage.getEnergyStored());
        this.fluidTank.writeToNBT(pTag);
        CompoundNBT infoTag = new CompoundNBT();
        infoTag.func_74768_a("Cooldown", this.cooldown);
        infoTag.func_74768_a("Delay", this.delay);
        pTag.func_218657_a("Info", (INBT)infoTag);
        return super.func_189515_b(pTag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT pTag) {
        if (pTag.func_74764_b("energy")) {
            this.energyStorage.setEnergy(pTag.func_74762_e("energy"));
        }
        this.fluidTank.readFromNBT(pTag);
        if (pTag.func_74764_b("Info")) {
            this.cooldown = pTag.func_74775_l("Info").func_74762_e("Cooldown");
            this.delay = pTag.func_74775_l("Info").func_74762_e("Delay");
        }
        super.func_230337_a_(state, pTag);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.delay = (Integer)CobblestoneSemanticsConfig.COBBLESTONE_MELTER_DELAY.get();
            boolean shouldUpdate = false;
            if (!this.fluidTank.isEmpty() && this.fluidTank.getFluid().getAmount() >= 1000 && this.energyStorage.getEnergyStored() + (Integer)CobblestoneSemanticsConfig.LAVA_GENERATOR_POWER_PER_LAVA_BUCKET.get() <= this.energyStorage.getMaxEnergyStored()) {
                ++this.cooldown;
                this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)));
                shouldUpdate = true;
            } else if (this.cooldown != 0) {
                this.cooldown = 0;
                if (this.fluidTank.getFluid().isEmpty()) {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
                }
                shouldUpdate = true;
            }
            if (this.cooldown % this.delay == 0 && this.cooldown != 0) {
                this.cooldown = 0;
                this.fluidTank.getFluid().shrink(1000);
                if (this.fluidTank.getFluid().isEmpty()) {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
                }
                this.energyStorage.addEnergy((Integer)CobblestoneSemanticsConfig.LAVA_GENERATOR_POWER_PER_LAVA_BUCKET.get());
            }
            if (shouldUpdate) {
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyLazyOptional.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        this.func_189515_b(tag);
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        if (tag != null) {
            this.func_230337_a_(state, tag);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        int oldCooldown = this.cooldown;
        int oldDelay = this.delay;
        CobblestoneSemanticsEnergyStorage oldEnergyStorage = this.energyStorage;
        FluidTank oldFluidTank = this.fluidTank;
        CompoundNBT tag = pkt.func_148857_g();
        this.handleUpdateTag(null, tag);
        if (oldCooldown != this.cooldown || oldDelay != this.delay || !Objects.equals((Object)oldEnergyStorage, (Object)this.energyStorage) || !Objects.equals(oldFluidTank, this.fluidTank)) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getDelay() {
        return this.delay;
    }
}

