/*
 * Decompiled with CFR 0.152.
 */
package Strikeboom.cobblestonesemantics.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class ClientUtil {
    public static void renderFluidBar(MatrixStack matrixStack, int xPosition, int yPosition, int width, int height, @Nullable FluidStack fluidStack, int capacityMb) {
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        if (fluidStack == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null || fluidStack.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)minecraft.func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
        int fluidColor = attributes.getColor(fluidStack);
        int amount = fluidStack.getAmount();
        int scaledAmount = amount * height / capacityMb;
        if (amount > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > height) {
            scaledAmount = height;
        }
        minecraft.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.color4f((float)((float)(fluidColor >> 16 & 0xFF) / 255.0f), (float)((float)(fluidColor >> 8 & 0xFF) / 255.0f), (float)((float)(fluidColor & 0xFF) / 255.0f), (float)((float)(fluidColor >> 24 & 0xFF) / 255.0f));
        int xTileCount = width / 16;
        int xRemainder = width - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = yPosition + height;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int w = xTile == xTileCount ? xRemainder : 16;
                int h = yTile == yTileCount ? yRemainder : 16;
                int x = xPosition + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (w <= 0 || h <= 0) continue;
                int maskTop = 16 - h;
                int maskRight = 16 - w;
                float uMin = fluidStillSprite.func_94209_e();
                float uMax = fluidStillSprite.func_94212_f();
                float vMin = fluidStillSprite.func_94206_g();
                float vMax = fluidStillSprite.func_94210_h();
                uMax -= (float)maskRight / 16.0f * (uMax - uMin);
                vMax -= (float)maskTop / 16.0f * (vMax - vMin);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferBuilder = tessellator.func_178180_c();
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferBuilder.func_227888_a_(matrix, (float)x, (float)(y + 16), 100.0f).func_225583_a_(uMin, vMax).func_181675_d();
                bufferBuilder.func_227888_a_(matrix, (float)(x + 16 - maskRight), (float)(y + 16), 100.0f).func_225583_a_(uMax, vMax).func_181675_d();
                bufferBuilder.func_227888_a_(matrix, (float)(x + 16 - maskRight), (float)(y + maskTop), 100.0f).func_225583_a_(uMax, vMin).func_181675_d();
                bufferBuilder.func_227888_a_(matrix, (float)x, (float)(y + maskTop), 100.0f).func_225583_a_(uMin, vMin).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static void drawFluidCapacityTooltip(int mouseX, int mouseY, int xPos, int yPos, int width, int height, ContainerScreen<?> gui, MatrixStack pMatrixStack, FluidStack fluidStack) {
        if (fluidStack != null && fluidStack.getFluid() != null && !fluidStack.getFluid().func_207187_a(Fluids.field_204541_a) && mouseX > xPos && mouseX < xPos + width && mouseY > yPos && mouseY < yPos + height) {
            gui.func_238652_a_(pMatrixStack, (ITextComponent)new StringTextComponent(fluidStack.getDisplayName().getString() + " " + fluidStack.getAmount() + " mB"), mouseX, mouseY);
        }
    }

    public static void drawEnergyTooltip(int mouseX, int mouseY, int xPos, int yPos, int width, int height, ContainerScreen<?> gui, MatrixStack pMatrixStack, int energy) {
        if (mouseX > xPos && mouseX < xPos + width && mouseY > yPos && mouseY < yPos + height) {
            gui.func_238652_a_(pMatrixStack, (ITextComponent)new StringTextComponent(energy + " RF/FE"), mouseX, mouseY);
        }
    }
}

