/*
 * Decompiled with CFR 0.152.
 */
package Strikeboom.cobblestonesemantics.blocks;

import Strikeboom.cobblestonesemantics.guis.tileentity.TileEntityCobbleGenerator;
import Strikeboom.cobblestonesemantics.guis.tileentity.customs.itemhandlers.CobblestoneGeneratorItemHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class CobblestoneGenerator
extends Block {
    int tier;
    int storageSlots;
    int delayUntilNextCobbleStone;

    public CobblestoneGenerator(int tier, int storageSlots, int delayUntilNextCobbleStone) {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(6.0f);
        this.func_149752_b(100.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.tier = tier;
        this.storageSlots = storageSlots;
        this.delayUntilNextCobbleStone = delayUntilNextCobbleStone;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCobbleGenerator(this.tier, this.storageSlots, this.delayUntilNextCobbleStone);
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        if (stack.func_77942_o()) {
            tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"tile.cobblestonesemantics.tooltip.saved", (Object[])new Object[0]));
        }
        tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tile.cobblestonesemantics.tooltip.outputs", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tile.cobblestonesemantics.tooltip.tier", (Object[])new Object[0]) + " " + this.tier);
        tooltip.add(I18n.func_135052_a((String)"tile.cobblestonesemantics.tooltip.storage", (Object[])new Object[0]) + " " + this.storageSlots * 64);
        tooltip.add(I18n.func_135052_a((String)"tile.cobblestonesemantics.tooltip.delay", (Object[])new Object[0]) + " " + this.delayUntilNextCobbleStone);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (!playerIn.func_70093_af()) {
                TileEntityCobbleGenerator te = (TileEntityCobbleGenerator)worldIn.func_175625_s(pos);
                ItemStack stack = ((CobblestoneGeneratorItemHandler)((Object)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null))).getLargestSlotThenRemove();
                if (!stack.func_190926_b() && !playerIn.field_71071_by.func_70441_a(stack)) {
                    InventoryHelper.func_180173_a((World)worldIn, (double)playerIn.field_70165_t, (double)playerIn.field_70163_u, (double)playerIn.field_70161_v, (ItemStack)stack);
                }
            } else if (playerIn.func_70093_af()) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(new TextComponentTranslation("tile.cobblestonesemantics.message.amount", new Object[0]).func_150254_d() + " " + ((TileEntityCobbleGenerator)worldIn.func_175625_s(pos)).getCobblestoneAmount()));
                return true;
            }
        }
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack stack = new ItemStack((Block)this);
        NBTTagCompound nbt = new NBTTagCompound();
        world.func_175625_s(pos).func_189515_b(nbt);
        stack.func_77982_d(nbt);
        drops.add((Object)stack);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77978_p() != null) {
            stack.func_77978_p().func_74768_a("x", pos.func_177958_n());
            stack.func_77978_p().func_74768_a("y", pos.func_177956_o());
            stack.func_77978_p().func_74768_a("z", pos.func_177952_p());
            worldIn.func_175625_s(pos).func_145839_a(stack.func_77978_p());
        }
    }

    public int getTier() {
        return this.tier;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }
}

