/*
 * Decompiled with CFR 0.152.
 */
package Strikeboom.cobblestonesemantics.guis.tileentity;

import Strikeboom.cobblestonesemantics.guis.tileentity.customs.itemhandlers.CobblestoneGeneratorItemHandler;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityCobbleGenerator
extends TileEntity
implements ITickable {
    ItemStackHandler handler;
    int tier = 1;
    int delayUntilNextCobbleStone = 1;
    int cooldown = 0;

    public TileEntityCobbleGenerator(int tier, int storageSlots, int delayUntilNextCobbleStone) {
        this.handler = new CobblestoneGeneratorItemHandler(storageSlots);
        this.tier = tier;
        this.delayUntilNextCobbleStone = delayUntilNextCobbleStone;
    }

    public TileEntityCobbleGenerator() {
        this.handler = new CobblestoneGeneratorItemHandler(1);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.cooldown = nbt.func_74762_e("cooldown");
        this.tier = nbt.func_74762_e("tier");
        this.delayUntilNextCobbleStone = nbt.func_74762_e("delayUntilNextCobbleStone");
        this.handler.deserializeNBT(nbt.func_74775_l("ItemStackHandler"));
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("ItemStackHandler", (NBTBase)this.handler.serializeNBT());
        nbt.func_74768_a("delayUntilNextCobbleStone", this.delayUntilNextCobbleStone);
        nbt.func_74768_a("tier", this.tier);
        nbt.func_74768_a("cooldown", this.cooldown);
        return super.func_189515_b(nbt);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.cobblestonesemantics.cobblegenerator" + this.tier + ".name", new Object[0]);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity downTE;
            TileEntity upTE;
            ++this.cooldown;
            if (this.cooldown % this.delayUntilNextCobbleStone == 0) {
                for (int i = 0; i < this.handler.getSlots(); ++i) {
                    if (!this.handler.getStackInSlot(i).func_190926_b()) {
                        if (this.handler.getStackInSlot(i).func_190916_E() >= this.handler.getSlotLimit(i)) continue;
                        this.handler.getStackInSlot(i).func_190917_f(1);
                        this.func_70296_d();
                        break;
                    }
                    this.handler.setStackInSlot(i, new ItemStack(Blocks.field_150347_e));
                    this.func_70296_d();
                    break;
                }
            }
            if ((upTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())) != null && upTE.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
                IItemHandler upHandler = (IItemHandler)upTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
                if (!this.handler.getStackInSlot(0).func_190926_b()) {
                    for (int i = 0; i < upHandler.getSlots(); ++i) {
                        if (upHandler.getStackInSlot(i).func_190916_E() >= upHandler.getSlotLimit(i)) continue;
                        upHandler.insertItem(i, this.handler.extractItem(((CobblestoneGeneratorItemHandler)this.handler).getLargestSlotIndex(), 64, false), false);
                    }
                }
            }
            if ((downTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) != null && downTE.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                IItemHandler downHandler = (IItemHandler)downTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                if (!this.handler.getStackInSlot(0).func_190926_b()) {
                    for (int i = 0; i < downHandler.getSlots(); ++i) {
                        if (downHandler.getStackInSlot(i).func_190916_E() >= downHandler.getSlotLimit(i)) continue;
                        downHandler.insertItem(i, this.handler.extractItem(((CobblestoneGeneratorItemHandler)this.handler).getLargestSlotIndex(), 64, false), false);
                    }
                }
            }
        }
    }

    public int getCobblestoneAmount() {
        int amount = 0;
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            amount += this.handler.getStackInSlot(i).func_190916_E();
        }
        return amount;
    }
}

