/*
 * Decompiled with CFR 0.152.
 */
package Strikeboom.cobblestonesemantics.handlers.util;

import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class ClientUtil {
    public static void renderFluidBar(Minecraft mc, FluidStack fluidStack, int fluidHandlerMaxCapacity, int xPos, int yPos, int width, int height) {
        if (fluidStack != null && fluidStack.getFluid() != null) {
            TextureAtlasSprite sprite = mc.func_147117_R().func_110572_b(fluidStack.getFluid().getStill().toString());
            int fluidHeight = fluidStack.amount * height / fluidHandlerMaxCapacity;
            if (fluidStack.amount > 0 && fluidHeight < 1) {
                fluidHeight = 1;
            }
            if (fluidHeight > height) {
                fluidHeight = height;
            }
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179131_c((float)((float)(fluidStack.getFluid().getColor() >> 16 & 0xFF) / 255.0f), (float)((float)(fluidStack.getFluid().getColor() >> 8 & 0xFF) / 255.0f), (float)((float)(fluidStack.getFluid().getColor() & 0xFF) / 255.0f), (float)((float)(fluidStack.getFluid().getColor() >> 24 & 0xFF) / 255.0f));
            int xTileCount = width / 16;
            int xRemainder = width - xTileCount * 16;
            int yTileCount = fluidHeight / 16;
            int yRemainder = fluidHeight - yTileCount * 16;
            int yStart = yPos + height;
            for (int xTile = 0; xTile <= xTileCount; ++xTile) {
                for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                    int w = xTile == xTileCount ? xRemainder : 16;
                    int h = yTile == yTileCount ? yRemainder : 16;
                    int x = xPos + xTile * 16;
                    int y = yStart - (yTile + 1) * 16;
                    if (w <= 0 || h <= 0) continue;
                    int maskTop = 16 - h;
                    int maskRight = 16 - w;
                    double uMin = sprite.func_94209_e();
                    double uMax = sprite.func_94212_f();
                    double vMin = sprite.func_94206_g();
                    double vMax = sprite.func_94210_h();
                    uMax -= (double)((float)maskRight / 16.0f) * (uMax - uMin);
                    vMax -= (double)((float)maskTop / 16.0f) * (vMax - vMin);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder bufferBuilder = tessellator.func_178180_c();
                    bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    bufferBuilder.func_181662_b((double)x, (double)(y + 16), 0.0).func_187315_a(uMin, vMax).func_181675_d();
                    bufferBuilder.func_181662_b((double)(x + 16 - maskRight), (double)(y + 16), 0.0).func_187315_a(uMax, vMax).func_181675_d();
                    bufferBuilder.func_181662_b((double)(x + 16 - maskRight), (double)(y + maskTop), 0.0).func_187315_a(uMax, vMin).func_181675_d();
                    bufferBuilder.func_181662_b((double)x, (double)(y + maskTop), 0.0).func_187315_a(uMin, vMin).func_181675_d();
                    tessellator.func_78381_a();
                }
            }
        }
    }

    public static void drawFluidCapacityTooltip(int mouseX, int mouseY, int xPos, int yPos, int width, int height, GuiScreen gui, FluidStack fluidStack) {
        if (fluidStack != null && fluidStack.getFluid() != null && mouseX > xPos && mouseX < xPos + width && mouseY > yPos && mouseY < yPos + height) {
            gui.func_146283_a(Collections.singletonList(fluidStack.getLocalizedName() + " " + fluidStack.amount + "mB"), mouseX, mouseY);
        }
    }

    public static void drawEnergyTooltip(int mouseX, int mouseY, int xPos, int yPos, int width, int height, GuiScreen gui, int energy) {
        if (mouseX > xPos && mouseX < xPos + width && mouseY > yPos && mouseY < yPos + height) {
            gui.func_146283_a(Collections.singletonList(energy + " RF/FE"), mouseX, mouseY);
        }
    }

    public static void registerFluidTexture(Fluid fluid) {
        final ModelResourceLocation loc = new ModelResourceLocation("cobblestonesemantics:" + fluid.getName(), "fluid");
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)fluid.getBlock()), stack -> loc);
        ModelLoader.setCustomStateMapper((Block)fluid.getBlock(), (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return loc;
            }
        });
    }
}

