/*
 * Decompiled with CFR 0.152.
 */
package Strikeboom.cobblestonesemantics.guis.blockentities;

import Strikeboom.cobblestonesemantics.guis.blockentities.energystorage.CobblestoneSemanticsEnergyStorage;
import Strikeboom.cobblestonesemantics.guis.blockentities.fluidtanks.LavaGeneratorFluidTank;
import Strikeboom.cobblestonesemantics.init.CobblestoneSemanticsBlockEntities;
import Strikeboom.cobblestonesemantics.init.CobblestoneSemanticsConfig;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class LavaGeneratorBlockEntity
extends BlockEntity {
    private final FluidTank fluidTank = new LavaGeneratorFluidTank(5000){

        protected void onContentsChanged() {
            LavaGeneratorBlockEntity.this.m_6596_();
            LavaGeneratorBlockEntity.this.f_58857_.m_7260_(LavaGeneratorBlockEntity.this.f_58858_, LavaGeneratorBlockEntity.this.m_58900_(), LavaGeneratorBlockEntity.this.m_58900_(), 3);
        }
    };
    private final LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> this.fluidTank);
    private final CobblestoneSemanticsEnergyStorage energyStorage = new CobblestoneSemanticsEnergyStorage(1000000, false, true){

        @Override
        protected void onEnergyChanged() {
            if (LavaGeneratorBlockEntity.this.f_58857_ != null) {
                LavaGeneratorBlockEntity.this.m_6596_();
                LavaGeneratorBlockEntity.this.f_58857_.m_7260_(LavaGeneratorBlockEntity.this.f_58858_, LavaGeneratorBlockEntity.this.m_58900_(), LavaGeneratorBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private final LazyOptional<IEnergyStorage> energyLazyOptional = LazyOptional.of(() -> this.energyStorage);
    private int cooldown = 0;
    private int delay = (Integer)CobblestoneSemanticsConfig.LAVA_GENERATOR_DELAY.get();

    public LavaGeneratorBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CobblestoneSemanticsBlockEntities.LAVA_GENERATOR_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public void m_7651_() {
        super.m_7651_();
        this.energyLazyOptional.invalidate();
        this.fluidHandlerLazyOptional.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128405_("energy", this.energyStorage.getEnergyStored());
        this.fluidTank.writeToNBT(pTag);
        CompoundTag infoTag = new CompoundTag();
        infoTag.m_128405_("Cooldown", this.cooldown);
        infoTag.m_128405_("Delay", this.delay);
        pTag.m_128365_("Info", (Tag)infoTag);
    }

    public void m_142466_(CompoundTag pTag) {
        if (pTag.m_128441_("energy")) {
            this.energyStorage.setEnergy(pTag.m_128451_("energy"));
        }
        this.fluidTank.readFromNBT(pTag);
        if (pTag.m_128441_("Info")) {
            this.cooldown = pTag.m_128469_("Info").m_128451_("Cooldown");
            this.delay = pTag.m_128469_("Info").m_128451_("Delay");
        }
        super.m_142466_(pTag);
    }

    public void tickServer() {
        this.delay = (Integer)CobblestoneSemanticsConfig.COBBLESTONE_MELTER_DELAY.get();
        boolean shouldUpdate = false;
        if (!this.fluidTank.isEmpty() && this.fluidTank.getFluid().getAmount() >= 1000 && this.energyStorage.getEnergyStored() + (Integer)CobblestoneSemanticsConfig.LAVA_GENERATOR_POWER_PER_LAVA_BUCKET.get() <= this.energyStorage.getMaxEnergyStored()) {
            ++this.cooldown;
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)));
            shouldUpdate = true;
        } else if (this.cooldown != 0) {
            this.cooldown = 0;
            if (this.fluidTank.getFluid().isEmpty()) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
            }
            shouldUpdate = true;
        }
        if (this.cooldown % this.delay == 0 && this.cooldown != 0) {
            this.cooldown = 0;
            this.fluidTank.getFluid().shrink(1000);
            if (this.fluidTank.getFluid().isEmpty()) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
            }
            this.energyStorage.addEnergy((Integer)CobblestoneSemanticsConfig.LAVA_GENERATOR_POWER_PER_LAVA_BUCKET.get());
        }
        if (shouldUpdate) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyLazyOptional.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        int oldCooldown = this.cooldown;
        int oldDelay = this.delay;
        CobblestoneSemanticsEnergyStorage oldEnergyStorage = this.energyStorage;
        FluidTank oldFluidTank = this.fluidTank;
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
        if (oldCooldown != this.cooldown || oldDelay != this.delay || !Objects.equals((Object)oldEnergyStorage, (Object)this.energyStorage) || !Objects.equals(oldFluidTank, this.fluidTank)) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getDelay() {
        return this.delay;
    }
}

