/*
 * Decompiled with CFR 0.152.
 */
package Strikeboom.cobblestonesemantics.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class ClientUtil {
    public static void renderFluidBar(PoseStack poseStack, int xPosition, int yPosition, int width, int height, @Nullable FluidStack fluidStack, int capacityMb) {
        RenderSystem.m_69478_();
        if (fluidStack == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null || fluidStack.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = attributes.getStillTexture();
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
        int fluidColor = attributes.getTintColor(fluidStack);
        int amount = fluidStack.getAmount();
        int scaledAmount = amount * height / capacityMb;
        if (amount > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > height) {
            scaledAmount = height;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        RenderSystem.m_157429_((float)((float)(fluidColor >> 16 & 0xFF) / 255.0f), (float)((float)(fluidColor >> 8 & 0xFF) / 255.0f), (float)((float)(fluidColor & 0xFF) / 255.0f), (float)((float)(fluidColor >> 24 & 0xFF) / 255.0f));
        int xTileCount = width / 16;
        int xRemainder = width - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = yPosition + height;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int w = xTile == xTileCount ? xRemainder : 16;
                int h = yTile == yTileCount ? yRemainder : 16;
                int x = xPosition + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (w <= 0 || h <= 0) continue;
                int maskTop = 16 - h;
                int maskRight = 16 - w;
                float uMin = fluidStillSprite.m_118409_();
                float uMax = fluidStillSprite.m_118410_();
                float vMin = fluidStillSprite.m_118411_();
                float vMax = fluidStillSprite.m_118412_();
                uMax -= (float)maskRight / 16.0f * (uMax - uMin);
                vMax -= (float)maskTop / 16.0f * (vMax - vMin);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder bufferBuilder = tessellator.m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferBuilder.m_85982_(matrix, (float)x, (float)(y + 16), 100.0f).m_7421_(uMin, vMax).m_5752_();
                bufferBuilder.m_85982_(matrix, (float)(x + 16 - maskRight), (float)(y + 16), 100.0f).m_7421_(uMax, vMax).m_5752_();
                bufferBuilder.m_85982_(matrix, (float)(x + 16 - maskRight), (float)(y + maskTop), 100.0f).m_7421_(uMax, vMin).m_5752_();
                bufferBuilder.m_85982_(matrix, (float)x, (float)(y + maskTop), 100.0f).m_7421_(uMin, vMin).m_5752_();
                tessellator.m_85914_();
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
    }

    public static void drawFluidCapacityTooltip(int mouseX, int mouseY, int xPos, int yPos, int width, int height, AbstractContainerScreen<?> gui, PoseStack pPoseStack, FluidStack fluidStack) {
        if (fluidStack != null && fluidStack.getFluid() != null && !fluidStack.getFluid().m_6212_(Fluids.f_76191_) && mouseX > xPos && mouseX < xPos + width && mouseY > yPos && mouseY < yPos + height) {
            gui.m_96602_(pPoseStack, (Component)Component.m_237113_((String)(fluidStack.getDisplayName().getString() + " " + fluidStack.getAmount() + " mB")), mouseX, mouseY);
        }
    }

    public static void drawEnergyTooltip(int mouseX, int mouseY, int xPos, int yPos, int width, int height, AbstractContainerScreen<?> gui, PoseStack pPoseStack, int energy) {
        if (mouseX > xPos && mouseX < xPos + width && mouseY > yPos && mouseY < yPos + height) {
            gui.m_96602_(pPoseStack, (Component)Component.m_237113_((String)(energy + " RF/FE")), mouseX, mouseY);
        }
    }
}

