/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.common.connection;

import com.ishland.raknetify.common.connection.SimpleMetricsLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.frame.FrameData;
import network.ycc.raknet.packet.FramedPacket;

public class MetricsSynchronizationHandler
extends ChannelDuplexHandler {
    private static final byte VERSION = 0;
    private ScheduledFuture<?> future;
    private ChannelHandlerContext ctx;
    private boolean isRemoteSupported = false;
    private long lastRecv = 0L;
    private int queuedBytes;
    private int burst;
    private double errorRate;
    private int tx;
    private int rx;

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.future = ctx.channel().eventLoop().scheduleAtFixedRate(this::sendSyncPacket, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSyncPacket() {
        RakNet.Config config;
        Object object = this.ctx.channel().config();
        if (object instanceof RakNet.Config && (object = (config = (RakNet.Config)object).getMetrics()) instanceof SimpleMetricsLogger) {
            SimpleMetricsLogger logger = (SimpleMetricsLogger)object;
            ByteBuf buffer = null;
            try {
                buffer = this.ctx.alloc().buffer(33);
                buffer.writeByte(0);
                buffer.writeLong(System.currentTimeMillis());
                buffer.writeInt(logger.getCurrentQueuedBytes());
                buffer.writeInt((int)(logger.getMeasureBurstTokens() + (long)config.getDefaultPendingFrameSets()));
                buffer.writeDouble(logger.getMeasureErrorRate());
                buffer.writeInt(logger.getMeasureTX());
                buffer.writeInt(logger.getMeasureRX());
                FrameData frameData = FrameData.create(this.ctx.alloc(), 251, buffer);
                frameData.setReliability(FramedPacket.Reliability.UNRELIABLE);
                this.ctx.write((Object)frameData);
            }
            finally {
                if (buffer != null) {
                    buffer.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FrameData frameData;
        if (msg instanceof FrameData && (frameData = (FrameData)msg).getDataSize() > 0 && frameData.getPacketId() == 251) {
            ByteBuf byteBuf = null;
            try {
                byteBuf = frameData.createData().skipBytes(1);
                byte version = byteBuf.readByte();
                if (version != 0) {
                    return;
                }
                long time = byteBuf.readLong();
                if (time < this.lastRecv) {
                    return;
                }
                this.lastRecv = time;
                this.isRemoteSupported = true;
                this.queuedBytes = byteBuf.readInt();
                this.burst = byteBuf.readInt();
                this.errorRate = byteBuf.readDouble();
                this.tx = byteBuf.readInt();
                this.rx = byteBuf.readInt();
            }
            finally {
                if (byteBuf != null) {
                    byteBuf.release();
                }
                frameData.release();
            }
            return;
        }
        super.channelRead(ctx, msg);
    }

    public boolean isRemoteSupported() {
        return this.isRemoteSupported;
    }

    public int getQueuedBytes() {
        return this.queuedBytes;
    }

    public int getBurst() {
        return this.burst;
    }

    public double getErrorRate() {
        return this.errorRate;
    }

    public int getTX() {
        return this.tx;
    }

    public int getRX() {
        return this.rx;
    }
}

