/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.velocity;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.ProxyServer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.slf4j.Logger;

@Plugin(id="raknetify")
public class RaknetifyVelocityPlugin {
    private static final ArrayList<Pattern> excludeRegex = new ArrayList();
    public static ProxyServer PROXY;
    public static Logger LOGGER;
    public static RaknetifyVelocityPlugin INSTANCE;
    public static URLClassLoader WRAPPER;
    @Inject
    private ProxyServer proxy;
    @Inject
    private Logger logger;

    private static boolean isExcluded(String name) {
        for (Pattern regex : excludeRegex) {
            if (!regex.matcher(name).find()) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void onProxyInit(ProxyInitializeEvent e) {
        INSTANCE = this;
        PROXY = this.proxy;
        LOGGER = this.logger;
        CodeSource codeSource = RaknetifyVelocityPlugin.class.getProtectionDomain().getCodeSource();
        if (codeSource != null && !RaknetifyVelocityPlugin.isDevLaunch()) {
            try {
                LOGGER.info("Bootstrapping raknetify in wrapped environment");
                RaknetifyURLClassLoader urlClassLoader = new RaknetifyURLClassLoader("raknetify wrapper", new URL[]{codeSource.getLocation()}, RaknetifyVelocityPlugin.class.getClassLoader());
                Class<?> launchWrapper = urlClassLoader.loadClass("com.ishland.raknetify.velocity.RaknetifyVelocityLaunchWrapper");
                Preconditions.checkState((launchWrapper.getClassLoader() == urlClassLoader ? 1 : 0) != 0, (Object)"Not launched in wrapper");
                WRAPPER = urlClassLoader;
                launchWrapper.getMethod("launch", new Class[0]).invoke(null, new Object[0]);
                return;
            }
            catch (Throwable t) {
                LOGGER.error("Error bootstrapping raknetify inside wrapped environment, running in normal environment instead", t);
            }
        }
        try {
            Class.forName("com.ishland.raknetify.velocity.RaknetifyVelocityLaunchWrapper").getMethod("launch", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isDevLaunch() {
        try {
            ClassLoader.getSystemClassLoader().loadClass("com.ishland.raknetify.velocity.RaknetifyVelocityPlugin");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        excludeRegex.add(Pattern.compile("it.unimi.dsi.fastutil.ints.*Int2ObjectLinked*"));
        excludeRegex.add(Pattern.compile("it.unimi.dsi.fastutil.ints.*Int2ObjectSorted*"));
        excludeRegex.add(Pattern.compile("it.unimi.dsi.fastutil.ints.*Int2ObjectAVL*"));
        excludeRegex.add(Pattern.compile("it.unimi.dsi.fastutil.ints.*Int2ObjectRB*"));
        excludeRegex.add(Pattern.compile("it.unimi.dsi.fastutil.ints.*Int2ObjectArray*"));
        excludeRegex.add(Pattern.compile("it.unimi.dsi.fastutil.ints.IntList*"));
        excludeRegex.add(Pattern.compile("it.unimi.dsi.fastutil.ints.AbstractIntList*"));
        excludeRegex.add(Pattern.compile("it.unimi.dsi.fastutil.ints.IntSorted*"));
        excludeRegex.add(Pattern.compile("it.unimi.dsi.fastutil.ints.AbstractIntSorted*"));
        excludeRegex.add(Pattern.compile("it.unimi.dsi.fastutil.ints.IntRB*"));
    }

    private static class RaknetifyURLClassLoader
    extends URLClassLoader {
        public RaknetifyURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public RaknetifyURLClassLoader(URL[] urls) {
            super(urls);
        }

        public RaknetifyURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
            super(urls, parent, factory);
        }

        public RaknetifyURLClassLoader(String name, URL[] urls, ClassLoader parent) {
            super(name, urls, parent);
        }

        public RaknetifyURLClassLoader(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
            super(name, urls, parent, factory);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (!(name.startsWith("com.ishland.raknetify") && !name.equals("com.ishland.raknetify.velocity.RaknetifyVelocityPlugin") || name.startsWith("network.ycc.raknet") || RaknetifyVelocityPlugin.isExcluded(name))) {
                try {
                    return Class.forName(name, true, this.getParent());
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                    // empty catch block
                }
            }
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                try {
                    Class<?> clazz = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
                catch (ClassNotFoundException e1) {
                    throw new ClassNotFoundException(name, e1);
                }
            }
        }
    }
}

