/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.velocity.connection;

import com.ishland.raknetify.common.util.ReflectionUtil;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import network.ycc.raknet.RakNet;

public class RakNetVelocityPingUpdater
extends ChannelDuplexHandler {
    public static final String NAME = "raknetify-velocity-ping-updater";
    private static final Method PLAYER_SET_PING;
    private final ConnectedPlayer player;
    ScheduledFuture<?> updateTask = null;

    public RakNetVelocityPingUpdater(ConnectedPlayer player) {
        this.player = Objects.requireNonNull(player);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        ChannelConfig channelConfig = ctx.channel().config();
        if (channelConfig instanceof RakNet.Config) {
            RakNet.Config config = (RakNet.Config)channelConfig;
            this.updateTask = ctx.channel().eventLoop().scheduleAtFixedRate(() -> {
                try {
                    PLAYER_SET_PING.invoke((Object)this.player, (config.getRTTNanos() + config.getRTTStdDevNanos()) / 1000000L);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }, 0L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.updateTask != null) {
            this.updateTask.cancel(false);
            this.updateTask = null;
        }
    }

    static {
        try {
            PLAYER_SET_PING = ReflectionUtil.accessible(ConnectedPlayer.class.getDeclaredMethod("setPing", Long.TYPE));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

