/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.velocity.connection;

import com.google.common.base.Preconditions;
import com.ishland.raknetify.common.Constants;
import com.ishland.raknetify.velocity.RaknetifyVelocityPlugin;
import com.velocitypowered.proxy.protocol.packet.KeepAlivePacket;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import network.ycc.raknet.RakNet;

public class RakNetVelocityServerChannelEventListener
extends ChannelDuplexHandler {
    public static final String NAME = "raknetify-bungee-downstream-event-listener";
    private final Channel clientChannel;

    public RakNetVelocityServerChannelEventListener(Channel clientChannel) {
        Preconditions.checkArgument((boolean)(clientChannel.config() instanceof RakNet.Config));
        this.clientChannel = clientChannel;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof KeepAlivePacket) {
            if (Constants.DEBUG) {
                RaknetifyVelocityPlugin.LOGGER.info("Received downstream keepalive, swallowing it");
            }
            long rttNanos = RakNet.config(this.clientChannel).getRTTNanos();
            ctx.channel().eventLoop().schedule(() -> ctx.writeAndFlush(msg), Math.max(rttNanos - 4000000L, 0L), TimeUnit.NANOSECONDS);
            return;
        }
        super.channelRead(ctx, msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        cause.printStackTrace();
        for (Map.Entry entry : ctx.channel().pipeline().toMap().entrySet()) {
            System.out.println("%s: %s".formatted(entry.getKey(), ((ChannelHandler)entry.getValue()).getClass().getName()));
        }
    }
}

