/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.AttributeKey;
import java.nio.channels.ClosedChannelException;
import network.ycc.raknet.frame.FrameData;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.packet.Packet;
import network.ycc.raknet.pipeline.DisconnectHandler;
import network.ycc.raknet.pipeline.FrameJoiner;
import network.ycc.raknet.pipeline.FrameOrderIn;
import network.ycc.raknet.pipeline.FrameOrderOut;
import network.ycc.raknet.pipeline.FrameSplitter;
import network.ycc.raknet.pipeline.FramedPacketCodec;
import network.ycc.raknet.pipeline.PingHandler;
import network.ycc.raknet.pipeline.PongHandler;
import network.ycc.raknet.pipeline.ReliabilityHandler;

public class RakNet {
    public static final AttributeKey<Boolean> WRITABLE = AttributeKey.valueOf((String)"RN_WRITABLE");
    public static final ChannelOption<Long> SERVER_ID = ChannelOption.valueOf((String)"RN_SERVER_ID");
    public static final ChannelOption<Long> CLIENT_ID = ChannelOption.valueOf((String)"RN_CLIENT_ID");
    public static final ChannelOption<MetricsLogger> METRICS = ChannelOption.valueOf((String)"RN_METRICS");
    public static final ChannelOption<Integer> MTU = ChannelOption.valueOf((String)"RN_MTU");
    public static final ChannelOption<Long> RTT = ChannelOption.valueOf((String)"RN_RTT");
    public static final ChannelOption<Integer> PROTOCOL_VERSION = ChannelOption.valueOf((String)"RN_PROTOCOL_VERSION");
    public static final ChannelOption<Magic> MAGIC = ChannelOption.valueOf((String)"RN_MAGIC");
    public static final ChannelOption<Long> RETRY_DELAY_NANOS = ChannelOption.valueOf((String)"RN_RETRY_DELAY_NANOS");
    public static final ChannelOption<Integer> MAX_CONNECTIONS = ChannelOption.valueOf((String)"RN_MAX_CONNECTIONS");
    public static final ChannelFutureListener INTERNAL_WRITE_LISTENER = future -> {
        if (!future.isSuccess() && !(future.cause() instanceof ClosedChannelException)) {
            future.channel().pipeline().fireExceptionCaught(future.cause());
            future.channel().close();
        }
    };

    public static Config config(ChannelHandlerContext ctx) {
        return RakNet.config(ctx.channel());
    }

    public static Config config(Channel channel) {
        return (Config)channel.config();
    }

    public static MetricsLogger metrics(ChannelHandlerContext ctx) {
        return RakNet.config(ctx).getMetrics();
    }

    public static interface Config
    extends ChannelConfig {
        public MetricsLogger getMetrics();

        public void setMetrics(MetricsLogger var1);

        public long getServerId();

        public void setServerId(long var1);

        public long getClientId();

        public void setClientId(long var1);

        public int getMTU();

        public void setMTU(int var1);

        public long getRetryDelayNanos();

        public void setRetryDelayNanos(long var1);

        public long getRTTNanos();

        public void setRTTNanos(long var1);

        public long getRTTStdDevNanos();

        public void updateRTTNanos(long var1);

        public int getMaxPendingFrameSets();

        public void setMaxPendingFrameSets(int var1);

        public int getDefaultPendingFrameSets();

        public void setDefaultPendingFrameSets(int var1);

        public int getMaxQueuedBytes();

        public void setMaxQueuedBytes(int var1);

        public Magic getMagic();

        public void setMagic(Magic var1);

        public Codec getCodec();

        public void setCodec(Codec var1);

        public int[] getProtocolVersions();

        public void setprotocolVersions(int[] var1);

        public boolean containsProtocolVersion(int var1);

        public int getProtocolVersion();

        public void setProtocolVersion(int var1);

        public int getMaxConnections();

        public void setMaxConnections(int var1);

        public boolean isIgnoreResendGauge();

        public void setIgnoreResendGauge(boolean var1);

        public boolean isNACKEnabled();

        public void setNACKEnabled(boolean var1);

        public boolean isNoDelayEnabled();

        public void setNoDelayEnabled(boolean var1);
    }

    public static interface MetricsLogger {
        default public void packetsIn(int delta) {
        }

        default public void framesIn(int delta) {
        }

        default public void frameError(int delta) {
        }

        default public void bytesIn(int delta) {
        }

        default public void packetsOut(int delta) {
        }

        default public void framesOut(int delta) {
        }

        default public void bytesOut(int delta) {
        }

        default public void bytesRecalled(int delta) {
        }

        default public void bytesACKd(int delta) {
        }

        default public void bytesNACKd(int delta) {
        }

        default public void acksSent(int delta) {
        }

        default public void nacksSent(int delta) {
        }

        default public void measureRTTns(long n) {
        }

        default public void measureRTTnsStdDev(long n) {
        }

        default public void measureBurstTokens(int n) {
        }

        default public void currentQueuedBytes(int bytes) {
        }
    }

    public static class PacketHandling
    extends ChannelInitializer<Channel> {
        public static final PacketHandling INSTANCE = new PacketHandling();

        protected void initChannel(Channel channel) {
            channel.pipeline().addLast("rn-disconnect", (ChannelHandler)DisconnectHandler.INSTANCE).addLast("rn-ping", (ChannelHandler)PingHandler.INSTANCE).addLast("rn-pong", (ChannelHandler)PongHandler.INSTANCE);
        }
    }

    public static class ReliableFrameHandling
    extends ChannelInitializer<Channel> {
        public static final ReliableFrameHandling INSTANCE = new ReliableFrameHandling();

        protected void initChannel(Channel channel) {
            channel.pipeline().addLast("rn-reliability", (ChannelHandler)new ReliabilityHandler()).addLast("rn-join", (ChannelHandler)new FrameJoiner()).addLast("rn-split", (ChannelHandler)new FrameSplitter()).addLast("rn-order-in", (ChannelHandler)new FrameOrderIn()).addLast("rn-order-out", (ChannelHandler)new FrameOrderOut()).addLast("rn-framed-codec", (ChannelHandler)new FramedPacketCodec());
        }
    }

    public static interface Magic {
        public void write(ByteBuf var1);

        public void read(ByteBuf var1);

        public void verify(Magic var1);

        public static class MagicMismatchException
        extends CorruptedFrameException {
            public static final long serialVersionUID = 590681756L;

            public MagicMismatchException() {
                super("Incorrect RakNet magic value");
            }

            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        }
    }

    public static interface Codec {
        public FrameData encode(FramedPacket var1, ByteBufAllocator var2);

        public void encode(Packet var1, ByteBuf var2);

        public ByteBuf produceEncoded(Packet var1, ByteBufAllocator var2);

        public Packet decode(ByteBuf var1);

        public FramedPacket decode(FrameData var1);

        public int packetIdFor(Class<? extends Packet> var1);
    }
}

