/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.client.channel;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Supplier;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.channel.DatagramChannelProxy;
import network.ycc.raknet.client.RakNetClient;
import network.ycc.raknet.client.pipeline.ConnectionInitializer;

public class RakNetClientChannel
extends DatagramChannelProxy {
    protected final ChannelPromise connectPromise = this.newPromise();

    public RakNetClientChannel() {
        this(NioDatagramChannel.class);
    }

    public RakNetClientChannel(Supplier<? extends DatagramChannel> ioChannelSupplier) {
        super(ioChannelSupplier);
        this.addDefaultPipeline();
    }

    public RakNetClientChannel(Class<? extends DatagramChannel> ioChannelType) {
        super(ioChannelType);
        this.addDefaultPipeline();
    }

    public ChannelFuture connectFuture() {
        return this.connectPromise;
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.connectPromise.isSuccess();
    }

    @Override
    public boolean isWritable() {
        Boolean result = (Boolean)this.attr(RakNet.WRITABLE).get();
        return (result == null || result != false) && super.isWritable();
    }

    protected void addDefaultPipeline() {
        this.pipeline().addLast(new ChannelHandler[]{this.newClientHandler()}).addLast(new ChannelHandler[]{RakNetClient.DefaultClientInitializer.INSTANCE});
        this.connectPromise.addListener(res -> {
            if (!res.isSuccess()) {
                this.close();
            }
        });
    }

    protected ChannelHandler newClientHandler() {
        return new ClientHandler();
    }

    protected class ClientHandler
    extends ChannelDuplexHandler {
        protected ClientHandler() {
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            try {
                if (!(remoteAddress instanceof InetSocketAddress)) {
                    throw new IllegalArgumentException("Provided remote address is not an InetSocketAddress");
                }
                if (RakNetClientChannel.this.listener.isActive()) {
                    throw new IllegalStateException("Channel connection already started");
                }
                ChannelFuture listenerConnect = RakNetClientChannel.this.listener.connect(remoteAddress, localAddress);
                listenerConnect.addListener(udpConnectResult -> {
                    if (udpConnectResult.isSuccess()) {
                        RakNetClientChannel.this.pipeline().replace("rn-init-connect", "rn-init-connect", (ChannelHandler)new ConnectionInitializer(RakNetClientChannel.this.connectPromise));
                    }
                });
                PromiseCombiner combiner = new PromiseCombiner();
                combiner.add((Future)listenerConnect);
                combiner.add((Future)RakNetClientChannel.this.connectPromise);
                combiner.finish((Promise)promise);
            }
            catch (Exception t) {
                promise.tryFailure((Throwable)t);
            }
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            RakNetClientChannel.this.listener.write(msg, RakNetClientChannel.this.wrapPromise(promise));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof DatagramPacket) {
                try {
                    DatagramPacket datagram = (DatagramPacket)msg;
                    if (datagram.sender() != null && !((InetSocketAddress)datagram.sender()).equals(RakNetClientChannel.this.remoteAddress())) return;
                    ctx.fireChannelRead((Object)((ByteBuf)datagram.content()).retain());
                    return;
                }
                finally {
                    ReferenceCountUtil.release((Object)msg);
                }
            } else {
                ctx.fireChannelRead(msg);
            }
        }

        public void read(ChannelHandlerContext ctx) {
        }
    }
}

