/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelPromise;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import java.util.Comparator;
import java.util.List;
import network.ycc.raknet.frame.FrameData;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.utils.UINT;

public final class Frame
extends AbstractReferenceCounted {
    public static final FrameComparator COMPARATOR = new FrameComparator();
    public static final int HEADER_SIZE = 24;
    protected static final int SPLIT_FLAG = 16;
    private static final ResourceLeakDetector<Frame> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(Frame.class);
    private static final Recycler<Frame> recycler = new Recycler<Frame>(){

        protected Frame newObject(Recycler.Handle<Frame> handle) {
            return new Frame(handle);
        }
    };
    private final Recycler.Handle<Frame> handle;
    private boolean hasSplit;
    private int reliableIndex;
    private int sequenceIndex;
    private int orderIndex;
    private int splitCount;
    private int splitID;
    private int splitIndex;
    private FrameData frameData = null;
    private ResourceLeakTracker<Frame> tracker = null;
    private ChannelPromise promise = null;

    private Frame(Recycler.Handle<Frame> handle) {
        this.handle = handle;
        this.setRefCnt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame read(ByteBuf buf) {
        Frame out = Frame.createRaw();
        try {
            short flags = buf.readUnsignedByte();
            int bitLength = buf.readUnsignedShort();
            int length = (bitLength + 8 - 1) / 8;
            boolean hasSplit = (flags & 0x10) != 0;
            FramedPacket.Reliability reliability = FramedPacket.Reliability.get(flags >> 5);
            short orderChannel = 0;
            if (reliability.isReliable) {
                out.reliableIndex = buf.readUnsignedMediumLE();
            }
            if (reliability.isSequenced) {
                out.sequenceIndex = buf.readUnsignedMediumLE();
            }
            if (reliability.isOrdered) {
                out.orderIndex = buf.readUnsignedMediumLE();
                orderChannel = buf.readUnsignedByte();
            }
            if (hasSplit) {
                out.splitCount = buf.readInt();
                out.splitID = buf.readUnsignedShort();
                out.splitIndex = buf.readInt();
                out.hasSplit = true;
            }
            out.frameData = FrameData.read(buf, length, hasSplit);
            out.frameData.setReliability(reliability);
            out.frameData.setOrderChannel(orderChannel);
            Frame frame = out.retain();
            return frame;
        }
        finally {
            out.release();
        }
    }

    public static Frame create(FrameData packet) {
        if (packet.getReliability().isOrdered) {
            throw new IllegalArgumentException("Must provided indices for ordered data.");
        }
        Frame out = Frame.createRaw();
        out.frameData = packet.retain();
        return out;
    }

    public static Frame createOrdered(FrameData packet, int orderIndex, int sequenceIndex) {
        if (!packet.getReliability().isOrdered) {
            throw new IllegalArgumentException("No indices needed for non-ordered data.");
        }
        Frame out = Frame.createRaw();
        out.frameData = packet.retain();
        out.orderIndex = orderIndex;
        out.sequenceIndex = sequenceIndex;
        return out;
    }

    private static Frame createRaw() {
        Frame out = (Frame)((Object)recycler.get());
        assert (out.refCnt() == 0);
        assert (out.tracker == null);
        assert (out.frameData == null);
        assert (out.promise == null);
        out.hasSplit = false;
        out.splitIndex = 0;
        out.splitID = 0;
        out.splitCount = 0;
        out.orderIndex = 0;
        out.sequenceIndex = 0;
        out.reliableIndex = 0;
        out.setRefCnt(1);
        out.tracker = leakDetector.track((Object)out);
        return out;
    }

    public ReferenceCounted touch(Object hint) {
        if (this.tracker != null) {
            this.tracker.record(hint);
        }
        this.frameData.touch(hint);
        return this;
    }

    public Frame completeFragment(ByteBuf fullData) {
        assert (this.frameData.isFragment());
        Frame out = Frame.createRaw();
        out.reliableIndex = this.reliableIndex;
        out.sequenceIndex = this.sequenceIndex;
        out.orderIndex = this.orderIndex;
        out.frameData = FrameData.read(fullData, fullData.readableBytes(), false);
        out.frameData.setOrderChannel(this.getOrderChannel());
        out.frameData.setReliability(this.getReliability());
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fragment(int splitID, int splitSize, int reliableIndex, List<Object> outList) {
        ByteBuf data = this.frameData.createData();
        try {
            int dataSplitSize = splitSize - 24;
            int splitCountTotal = (data.readableBytes() + dataSplitSize - 1) / dataSplitSize;
            for (int splitIndexIterator = 0; splitIndexIterator < splitCountTotal; ++splitIndexIterator) {
                int length = Math.min(dataSplitSize, data.readableBytes());
                Frame out = Frame.createRaw();
                out.reliableIndex = reliableIndex;
                out.sequenceIndex = this.sequenceIndex;
                out.orderIndex = this.orderIndex;
                out.splitCount = splitCountTotal;
                out.splitID = splitID;
                out.splitIndex = splitIndexIterator;
                out.hasSplit = true;
                out.frameData = FrameData.read(data, length, true);
                out.frameData.setOrderChannel(this.getOrderChannel());
                out.frameData.setReliability(this.getReliability().makeReliable());
                assert (out.frameData.isFragment());
                if (out.getRoughPacketSize() > splitSize) {
                    throw new IllegalStateException("mtu fragment mismatch");
                }
                reliableIndex = UINT.B3.plus(reliableIndex, 1);
                outList.add((Object)out);
            }
            assert (!data.isReadable());
            int n = splitCountTotal;
            return n;
        }
        finally {
            data.release();
        }
    }

    public ByteBuf retainedFragmentData() {
        assert (this.frameData.isFragment());
        return this.frameData.createData();
    }

    public Frame retain() {
        return (Frame)super.retain();
    }

    protected void deallocate() {
        if (this.frameData != null) {
            this.frameData.release();
            this.frameData = null;
        }
        if (this.tracker != null) {
            this.tracker.close((Object)this);
            this.tracker = null;
        }
        this.promise = null;
        this.handle.recycle((Object)this);
    }

    public FrameData retainedFrameData() {
        return this.frameData.retain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produce(ByteBufAllocator alloc, CompositeByteBuf out) {
        ByteBuf header = alloc.ioBuffer(24, 24);
        try {
            this.writeHeader(header);
            out.addComponent(true, header.retain());
            out.addComponent(true, this.frameData.createData());
        }
        finally {
            header.release();
        }
    }

    public void write(ByteBuf out) {
        this.writeHeader(out);
        this.frameData.write(out);
    }

    protected void writeHeader(ByteBuf out) {
        out.writeByte(this.getReliability().code() << 5 | (this.hasSplit ? 16 : 0));
        out.writeShort(this.frameData.getDataSize() * 8);
        assert (!this.hasSplit || this.getReliability().isReliable);
        if (this.getReliability().isReliable) {
            out.writeMediumLE(this.reliableIndex);
        }
        if (this.getReliability().isSequenced) {
            out.writeMediumLE(this.sequenceIndex);
        }
        if (this.getReliability().isOrdered) {
            out.writeMediumLE(this.orderIndex);
            out.writeByte(this.getOrderChannel());
        }
        if (this.hasSplit) {
            out.writeInt(this.splitCount);
            out.writeShort(this.splitID);
            out.writeInt(this.splitIndex);
        }
    }

    public FramedPacket.Reliability getReliability() {
        return this.frameData.getReliability();
    }

    public int getSequenceIndex() {
        return this.sequenceIndex;
    }

    public int getOrderChannel() {
        return this.frameData.getOrderChannel();
    }

    public int getOrderIndex() {
        return this.orderIndex;
    }

    public boolean hasSplit() {
        return this.hasSplit;
    }

    public int getSplitId() {
        return this.splitID;
    }

    public int getSplitIndex() {
        return this.splitIndex;
    }

    public int getSplitCount() {
        return this.splitCount;
    }

    public int getDataSize() {
        return this.frameData.getDataSize();
    }

    public int getRoughPacketSize() {
        return this.getDataSize() + 24;
    }

    public void setReliableIndex(int reliableIndex) {
        this.reliableIndex = reliableIndex;
    }

    public int getReliableIndex() {
        return this.reliableIndex;
    }

    public ChannelPromise getPromise() {
        return this.promise;
    }

    public void setPromise(ChannelPromise promise) {
        this.promise = promise;
    }

    protected static final class FrameComparator
    implements Comparator<Frame> {
        protected FrameComparator() {
        }

        @Override
        public int compare(Frame a, Frame b) {
            if (a == b) {
                return 0;
            }
            if (!a.getReliability().isReliable) {
                return -1;
            }
            if (!b.getReliability().isReliable) {
                return 1;
            }
            return UINT.B3.minusWrap(a.reliableIndex, b.reliableIndex) < 0 ? -1 : 1;
        }
    }
}

