/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import network.ycc.raknet.packet.FramedPacket;

public final class FrameData
extends AbstractReferenceCounted
implements FramedPacket {
    private static final ResourceLeakDetector<FrameData> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(FrameData.class);
    private static final Recycler<FrameData> recycler = new Recycler<FrameData>(){

        protected FrameData newObject(Recycler.Handle<FrameData> handle) {
            return new FrameData(handle);
        }
    };
    private final Recycler.Handle<FrameData> handle;
    private ResourceLeakTracker<FrameData> tracker;
    private int orderId;
    private boolean fragment;
    private ByteBuf data;
    private FramedPacket.Reliability reliability;

    private FrameData(Recycler.Handle<FrameData> handle) {
        this.handle = handle;
        this.setRefCnt(0);
    }

    private static FrameData createRaw() {
        FrameData out = (FrameData)recycler.get();
        assert (out.refCnt() == 0 && out.tracker == null) : "bad reuse";
        out.orderId = 0;
        out.fragment = false;
        out.data = null;
        out.reliability = FramedPacket.Reliability.RELIABLE_ORDERED;
        out.setRefCnt(1);
        out.tracker = leakDetector.track((Object)out);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameData create(ByteBufAllocator alloc, int packetId, ByteBuf buf) {
        CompositeByteBuf out = alloc.compositeDirectBuffer(2);
        try {
            out.addComponent(true, alloc.ioBuffer(1, 1).writeByte(packetId));
            out.addComponent(true, buf.retain());
            FrameData frameData = FrameData.read((ByteBuf)out, out.readableBytes(), false);
            return frameData;
        }
        finally {
            out.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameData read(ByteBuf buf, int length, boolean fragment) {
        assert (length > 0);
        FrameData packet = FrameData.createRaw();
        try {
            packet.data = buf.readRetainedSlice(length);
            packet.fragment = fragment;
            assert (packet.getDataSize() == length);
            FrameData frameData = packet.retain();
            return frameData;
        }
        finally {
            packet.release();
        }
    }

    public void write(ByteBuf out) {
        out.writeBytes(this.data, this.data.readerIndex(), this.data.readableBytes());
    }

    public ByteBuf createData() {
        return this.data.retainedDuplicate();
    }

    public FrameData retain() {
        return (FrameData)super.retain();
    }

    protected void deallocate() {
        if (this.data != null) {
            this.data.release();
            this.data = null;
        }
        if (this.tracker != null) {
            this.tracker.close((Object)this);
            this.tracker = null;
        }
        this.handle.recycle((Object)this);
    }

    public String toString() {
        return String.format("PacketData(%s, length: %s, framed: %s, packetId: %s)", new Object[]{this.getReliability(), this.getDataSize(), this.isFragment(), this.fragment ? "n/a" : String.format("%02x", this.getPacketId())});
    }

    public ReferenceCounted touch(Object hint) {
        if (this.tracker != null) {
            this.tracker.record(hint);
        }
        this.data.touch(hint);
        return this;
    }

    public int getPacketId() {
        assert (!this.fragment);
        return this.data.getUnsignedByte(this.data.readerIndex());
    }

    public int getDataSize() {
        return this.data.readableBytes();
    }

    @Override
    public FramedPacket.Reliability getReliability() {
        return this.reliability;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    @Override
    public void setReliability(FramedPacket.Reliability reliability) {
        this.reliability = reliability;
    }

    @Override
    public int getOrderChannel() {
        return this.orderId;
    }

    @Override
    public void setOrderChannel(int orderChannel) {
        this.orderId = orderChannel;
    }
}

