/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.packet;

import io.netty.buffer.ByteBuf;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.packet.Packet;
import network.ycc.raknet.packet.SimpleFramedPacket;

public class ConnectionRequest
extends SimpleFramedPacket
implements Packet.ClientIdConnection {
    protected long clientId;
    protected long timestamp;

    public ConnectionRequest() {
        this.reliability = FramedPacket.Reliability.RELIABLE;
    }

    public ConnectionRequest(long clientId) {
        this();
        this.clientId = clientId;
        this.timestamp = System.nanoTime();
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.clientId);
        buf.writeLong(this.timestamp);
        buf.writeBoolean(false);
    }

    @Override
    public void decode(ByteBuf buf) {
        this.clientId = buf.readLong();
        this.timestamp = buf.readLong();
        buf.readBoolean();
    }

    @Override
    public long getClientId() {
        return this.clientId;
    }

    public void setClientId(long clientId) {
        this.clientId = clientId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

