/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.packet;

import io.netty.buffer.ByteBuf;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.config.DefaultMagic;
import network.ycc.raknet.packet.Packet;
import network.ycc.raknet.packet.SimplePacket;

public class ConnectionRequest1
extends SimplePacket
implements Packet {
    private RakNet.Magic magic;
    private int protocolVersion;
    private int mtu;

    public ConnectionRequest1() {
    }

    public ConnectionRequest1(RakNet.Magic magic, int protocolVersion, int mtu) {
        this.magic = magic;
        this.protocolVersion = protocolVersion;
        this.mtu = mtu;
    }

    @Override
    public void encode(ByteBuf buf) {
        this.magic.write(buf);
        buf.writeByte(this.protocolVersion);
        buf.writeZero(this.mtu - buf.readableBytes());
    }

    @Override
    public void decode(ByteBuf buf) {
        this.mtu = buf.readableBytes();
        this.magic = DefaultMagic.decode(buf);
        this.protocolVersion = buf.readByte();
        buf.skipBytes(buf.readableBytes());
        if (this.mtu < 128) {
            throw new IllegalArgumentException("ConnectionRequest1 MTU is too small");
        }
        if (this.mtu > 8192) {
            this.mtu = 8192;
        }
    }

    public RakNet.Magic getMagic() {
        return this.magic;
    }

    public void setMagic(RakNet.Magic magic) {
        this.magic = magic;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public int getMtu() {
        return this.mtu;
    }

    public void setMtu(int mtu) {
        this.mtu = mtu;
    }
}

