/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.packet;

import io.netty.buffer.ByteBuf;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.packet.SimpleFramedPacket;

public class Ping
extends SimpleFramedPacket {
    protected long timestamp;

    public Ping() {
        this.timestamp = System.nanoTime();
        this.reliability = FramedPacket.Reliability.UNRELIABLE;
    }

    public Ping(long timestamp) {
        this.timestamp = timestamp;
    }

    public static Ping newReliablePing() {
        Ping out = new Ping();
        out.reliability = FramedPacket.Reliability.RELIABLE;
        return out;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.timestamp);
    }

    @Override
    public void decode(ByteBuf buf) {
        this.timestamp = buf.readLong();
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

