/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.packet;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.packet.SimpleFramedPacket;

public class ServerHandshake
extends SimpleFramedPacket {
    private InetSocketAddress clientAddr;
    private long timestamp;
    private int nExtraAddresses;

    public ServerHandshake() {
        this.reliability = FramedPacket.Reliability.RELIABLE;
    }

    public ServerHandshake(InetSocketAddress clientAddr, long timestamp) {
        this(clientAddr, timestamp, 20);
    }

    public ServerHandshake(InetSocketAddress clientAddr, long timestamp, int nExtraAddresses) {
        this();
        this.clientAddr = clientAddr;
        this.timestamp = timestamp;
        this.nExtraAddresses = nExtraAddresses;
    }

    @Override
    public void encode(ByteBuf buf) {
        ServerHandshake.writeAddress(buf, this.clientAddr);
        buf.writeShort(0);
        for (int i = 0; i < this.nExtraAddresses; ++i) {
            ServerHandshake.writeAddress(buf);
        }
        buf.writeLong(this.timestamp);
        buf.writeLong(System.currentTimeMillis());
    }

    @Override
    public void decode(ByteBuf buf) {
        this.clientAddr = ServerHandshake.readAddress(buf);
        buf.readShort();
        this.nExtraAddresses = 0;
        while (buf.readableBytes() > 16) {
            ServerHandshake.readAddress(buf);
            ++this.nExtraAddresses;
        }
        this.timestamp = buf.readLong();
        this.timestamp = buf.readLong();
    }

    public InetSocketAddress getClientAddr() {
        return this.clientAddr;
    }

    public void setClientAddr(InetSocketAddress clientAddr) {
        this.clientAddr = clientAddr;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getnExtraAddresses() {
        return this.nExtraAddresses;
    }

    public void setnExtraAddresses(int nExtraAddresses) {
        this.nExtraAddresses = nExtraAddresses;
    }
}

