/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.packet;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import network.ycc.raknet.packet.Packet;

public abstract class SimplePacket
implements Packet {
    private static final InetSocketAddress NULL_ADDR = new InetSocketAddress(0);

    public static void writeString(ByteBuf buf, String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        buf.writeShort(bytes.length);
        buf.writeBytes(bytes);
    }

    public static String readString(ByteBuf buf) {
        byte[] bytes = new byte[buf.readShort()];
        buf.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static InetSocketAddress readAddress(ByteBuf buf) {
        int port;
        byte[] addr;
        byte type = buf.readByte();
        if (type == 4) {
            int addri = ~buf.readInt();
            addr = ByteBuffer.allocate(4).putInt(addri).array();
            port = buf.readUnsignedShort();
        } else if (type == 6) {
            buf.skipBytes(2);
            port = buf.readUnsignedShort();
            buf.skipBytes(4);
            addr = new byte[16];
            buf.readBytes(addr);
            buf.skipBytes(4);
        } else {
            throw new DecoderException("Unknown inet addr version: " + type);
        }
        try {
            return new InetSocketAddress(InetAddress.getByAddress(addr), port);
        }
        catch (UnknownHostException e) {
            throw new DecoderException("Unexpected error", (Throwable)e);
        }
    }

    public static void writeAddress(ByteBuf buf) {
        SimplePacket.writeAddress(buf, NULL_ADDR);
    }

    public static void writeAddress(ByteBuf buf, InetSocketAddress address) {
        InetAddress addr = address.getAddress();
        if (addr instanceof Inet4Address) {
            buf.writeByte(4);
            int addri = ByteBuffer.wrap(addr.getAddress()).getInt();
            buf.writeInt(~addri);
            buf.writeShort(address.getPort());
        } else if (addr instanceof Inet6Address) {
            buf.writeByte(6);
            buf.writeShort(10);
            buf.writeShort(address.getPort());
            buf.writeInt(0);
            buf.writeBytes(addr.getAddress());
            buf.writeInt(0);
        } else {
            throw new EncoderException("Unknown inet addr version: " + addr.getClass().getName());
        }
    }

    public abstract void encode(ByteBuf var1);

    public abstract void decode(ByteBuf var1);

    public String toString() {
        return this.getClass().getSimpleName() + "()";
    }
}

