/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.packet;

import io.netty.buffer.ByteBuf;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.config.DefaultMagic;
import network.ycc.raknet.packet.Packet;
import network.ycc.raknet.packet.SimplePacket;

public class UnconnectedPong
extends SimplePacket
implements Packet {
    private long clientTime = 0L;
    private long serverId = 0L;
    private RakNet.Magic magic;
    private String info = "";

    public UnconnectedPong() {
    }

    public UnconnectedPong(long clientTime, long serverId, RakNet.Magic magic, String info) {
        this.clientTime = clientTime;
        this.serverId = serverId;
        this.magic = magic;
        this.info = info;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.clientTime);
        buf.writeLong(this.serverId);
        this.magic.write(buf);
        UnconnectedPong.writeString(buf, this.info);
    }

    @Override
    public void decode(ByteBuf buf) {
        this.clientTime = buf.readLong();
        this.serverId = buf.readLong();
        this.magic = DefaultMagic.decode(buf);
        this.info = UnconnectedPong.readString(buf);
    }

    public long getClientTime() {
        return this.clientTime;
    }

    public void setClientTime(long clientTime) {
        this.clientTime = clientTime;
    }

    public long getServerId() {
        return this.serverId;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    public RakNet.Magic getMagic() {
        return this.magic;
    }

    public void setMagic(RakNet.Magic magic) {
        this.magic = magic;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }
}

