/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.pipeline;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import network.ycc.raknet.packet.Disconnect;

@ChannelHandler.Sharable
public class DisconnectHandler
extends ChannelDuplexHandler {
    public static final String NAME = "rn-disconnect";
    public static final DisconnectHandler INSTANCE = new DisconnectHandler();

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Disconnect) {
            ReferenceCountUtil.release((Object)msg);
            ctx.pipeline().remove((ChannelHandler)this);
            ctx.channel().flush().close();
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (ctx.channel().isActive()) {
            ChannelPromise disconnectPromise = ctx.newPromise();
            ScheduledFuture timeout = ctx.channel().eventLoop().schedule(() -> {
                disconnectPromise.trySuccess();
                throw new SocketTimeoutException();
            }, 3L, TimeUnit.SECONDS);
            ctx.channel().writeAndFlush((Object)new Disconnect()).addListener(f -> disconnectPromise.trySuccess());
            disconnectPromise.addListener(f -> {
                timeout.cancel(false);
                ctx.close(promise);
            });
        } else {
            ctx.close(promise);
        }
    }
}

