/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.pipeline;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.frame.Frame;
import network.ycc.raknet.frame.FrameData;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.utils.UINT;

public class FrameOrderOut
extends MessageToMessageEncoder<FramedPacket> {
    public static final String NAME = "rn-order-out";
    protected int[] nextOrderIndex = new int[8];
    protected int[] nextSequenceIndex = new int[8];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, FramedPacket packet, List<Object> list) {
        RakNet.Config config = RakNet.config(ctx);
        FrameData data = config.getCodec().encode(packet, ctx.alloc());
        try {
            if (data.getReliability().isOrdered) {
                int channel = data.getOrderChannel();
                int sequenceIndex = data.getReliability().isSequenced ? this.getNextSequenceIndex(channel) : 0;
                list.add((Object)Frame.createOrdered(data, this.getNextOrderIndex(channel), sequenceIndex));
            } else {
                list.add((Object)Frame.create(data));
            }
        }
        finally {
            data.release();
        }
    }

    protected int getNextOrderIndex(int channel) {
        int orderIndex = this.nextOrderIndex[channel];
        this.nextOrderIndex[channel] = UINT.B3.plus(this.nextOrderIndex[channel], 1);
        return orderIndex;
    }

    protected int getNextSequenceIndex(int channel) {
        int sequenceIndex = this.nextSequenceIndex[channel];
        this.nextSequenceIndex[channel] = UINT.B3.plus(this.nextSequenceIndex[channel], 1);
        return sequenceIndex;
    }
}

