/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.server.channel;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.config.DefaultConfig;
import network.ycc.raknet.pipeline.FlushTickHandler;
import network.ycc.raknet.server.RakNetServer;
import network.ycc.raknet.server.channel.ChannelUtil;
import network.ycc.raknet.server.channel.RakNetApplicationChannel;
import network.ycc.raknet.server.channel.RakNetServerChannel;
import network.ycc.raknet.server.pipeline.ConnectionInitializer;

public class RakNetChildChannel
extends AbstractChannel {
    public static final String WRITE_HANDLER_NAME = "rn-child-channel-write-handler";
    private static final ChannelMetadata metadata = new ChannelMetadata(false);
    protected final ChannelPromise connectPromise;
    protected final ChannelPromise closePromise;
    protected final RakNet.Config config;
    protected final InetSocketAddress remoteAddress;
    protected final InetSocketAddress localAddress;
    protected final RakNetApplicationChannel applicationChannel;
    protected final AtomicBoolean isRegisteringApplicationChannel = new AtomicBoolean(false);
    protected final Queue<Runnable> pendingApplicationChannelOperations = new LinkedList<Runnable>();
    protected final Consumer<Channel> registerChannel;
    private final DatagramChannel listener;
    protected volatile boolean open = true;

    public RakNetChildChannel(Supplier<? extends DatagramChannel> ioChannelSupplier, Channel parent, InetSocketAddress remoteAddress, InetSocketAddress localAddress, Consumer<Channel> registerChannel) {
        super(parent);
        this.listener = ioChannelSupplier.get();
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
        this.registerChannel = Objects.requireNonNull(registerChannel);
        this.config = new DefaultConfig((Channel)this);
        this.connectPromise = this.newPromise();
        this.closePromise = this.newPromise();
        this.config.setMetrics((RakNet.MetricsLogger)parent.config().getOption(RakNet.METRICS));
        this.config.setServerId((Long)parent.config().getOption(RakNet.SERVER_ID));
        this.applicationChannel = new RakNetApplicationChannel(this);
        this.pipeline().addLast(WRITE_HANDLER_NAME, (ChannelHandler)new WriteHandler());
        this.addDefaultPipeline();
    }

    protected void addDefaultPipeline() {
        this.pipeline().addLast(new ChannelHandler[]{RakNetServer.DefaultChildInitializer.INSTANCE});
        this.connectPromise.addListener(x2 -> {
            if (!x2.isSuccess()) {
                this.applicationChannel.close();
                this.close();
            }
        });
        this.pipeline().addLast(new ChannelHandler[]{new ChannelInitializer<RakNetChildChannel>(){

            protected void initChannel(RakNetChildChannel ch) {
                RakNetChildChannel.this.pipeline().replace("rn-init-connect", "rn-init-connect", (ChannelHandler)new ConnectionInitializer(RakNetChildChannel.this.connectPromise));
                RakNetChildChannel.this.pipeline().addLast("rn-server-parent-threaded-read-handler", (ChannelHandler)new ReadHandler());
            }
        }});
    }

    protected void registerApplicationChannelIfNecessary() {
        if (!this.applicationChannel.isRegistered()) {
            if (this.isRegisteringApplicationChannel.compareAndSet(false, true)) {
                this.registerChannel.accept((Channel)this.applicationChannel);
            }
        } else if (!this.pendingApplicationChannelOperations.isEmpty()) {
            Runnable r;
            while ((r = this.pendingApplicationChannelOperations.poll()) != null) {
                try {
                    r.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public ChannelFuture connectFuture() {
        return this.connectPromise;
    }

    public boolean isWritable() {
        Boolean result = (Boolean)this.attr(RakNet.WRITABLE).get();
        return (result == null || result != false) && this.parent().isWritable();
    }

    public long bytesBeforeUnwritable() {
        return this.parent().bytesBeforeUnwritable();
    }

    public long bytesBeforeWritable() {
        return this.parent().bytesBeforeWritable();
    }

    public RakNetServerChannel parent() {
        return (RakNetServerChannel)super.parent();
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new AbstractChannel.AbstractUnsafe(){

            public void connect(SocketAddress addr1, SocketAddress addr2, ChannelPromise pr) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected boolean isCompatible(EventLoop eventloop) {
        return true;
    }

    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    protected SocketAddress remoteAddress0() {
        return this.remoteAddress;
    }

    protected void doBind(SocketAddress addr) {
        throw new UnsupportedOperationException();
    }

    protected void doDisconnect() {
        this.close();
    }

    protected void doClose() {
        this.open = false;
        if (this.applicationChannel.isRegistered()) {
            this.applicationChannel.close();
        }
    }

    protected void doBeginRead() {
    }

    protected void doWrite(ChannelOutboundBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public RakNet.Config config() {
        return this.config;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isActive() {
        return this.isOpen() && this.parent().isActive() && this.connectPromise.isSuccess();
    }

    public ChannelMetadata metadata() {
        return metadata;
    }

    public RakNetApplicationChannel getApplicationChannel() {
        return this.applicationChannel;
    }

    protected synchronized ChannelPromise initStandaloneListener() {
        ChannelPromise channelPromise = this.newPromise();
        if (this.listener.isRegistered()) {
            System.out.println("Already registered?");
            channelPromise.trySuccess();
            return channelPromise;
        }
        ChannelUtil.setChannelOptions((Channel)this.listener, this.parent().getChannelParameters().childOptions);
        this.listener.config().setReuseAddress(true).setAutoRead(true).setRecvByteBufAllocator(this.parent().backingChannel().config().getRecvByteBufAllocator());
        this.listener.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.fireChannelActive();
                ctx.read();
                RakNetChildChannel.this.pipeline().replace(RakNetChildChannel.WRITE_HANDLER_NAME, RakNetChildChannel.WRITE_HANDLER_NAME, (ChannelHandler)new ListenerOutboundProxy());
                ctx.pipeline().remove((ChannelHandler)this);
            }
        }}).addLast(WRITE_HANDLER_NAME, (ChannelHandler)new ListenerInboundProxy()).addLast(new ChannelHandler[]{new FlushConsolidationHandler(256, true)});
        this.eventLoop().register((Channel)this.listener).addListener(future -> {
            if (future.isSuccess()) {
                this.listener.connect((SocketAddress)this.remoteAddress, (SocketAddress)this.localAddress).addListener(future1 -> {
                    if (future1.isDone()) {
                        channelPromise.trySuccess();
                    } else {
                        channelPromise.setFailure(future1.cause());
                        future1.cause().printStackTrace();
                    }
                });
            } else {
                channelPromise.setFailure(future.cause());
                future.cause().printStackTrace();
            }
        });
        return channelPromise;
    }

    protected ChannelPromise wrapPromise(ChannelPromise in) {
        ChannelPromise out = this.listener.newPromise();
        out.addListener(res -> {
            if (res.isSuccess()) {
                in.trySuccess();
            } else {
                in.tryFailure(res.cause());
            }
        });
        return out;
    }

    protected class WriteHandler
    extends ChannelOutboundHandlerAdapter {
        protected boolean needsFlush = false;

        protected WriteHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            if (msg instanceof ByteBuf) {
                this.needsFlush = true;
                promise.trySuccess();
                RakNetChildChannel.this.parent().write(new DatagramPacket((ByteBuf)msg, RakNetChildChannel.this.remoteAddress, RakNetChildChannel.this.localAddress)).addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
            } else {
                ctx.write(msg, promise);
            }
        }

        public void flush(ChannelHandlerContext ctx) {
            if (this.needsFlush) {
                this.needsFlush = false;
                RakNetChildChannel.this.parent().flush();
            }
        }

        public void read(ChannelHandlerContext ctx) {
        }
    }

    protected class ListenerInboundProxy
    implements ChannelInboundHandler {
        protected ListenerInboundProxy() {
        }

        public void channelRegistered(ChannelHandlerContext ctx) {
        }

        public void channelUnregistered(ChannelHandlerContext ctx) {
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            assert (RakNetChildChannel.this.listener.eventLoop().inEventLoop());
        }

        public void channelActive(ChannelHandlerContext ctx) {
        }

        public void channelInactive(ChannelHandlerContext ctx) {
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof DatagramPacket) {
                DatagramPacket datagram = (DatagramPacket)msg;
                try {
                    if (!RakNetChildChannel.this.isActive()) return;
                    ByteBuf retained = ((ByteBuf)datagram.content()).retain();
                    RakNetChildChannel.this.pipeline().fireChannelRead((Object)retained);
                    return;
                }
                finally {
                    datagram.release();
                }
            } else {
                RakNetChildChannel.this.pipeline().fireChannelRead(msg);
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            RakNetChildChannel.this.pipeline().fireChannelReadComplete();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            RakNetChildChannel.this.pipeline().fireChannelWritabilityChanged();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (cause instanceof ClosedChannelException) {
                return;
            }
            RakNetChildChannel.this.pipeline().fireExceptionCaught(cause);
        }
    }

    protected class ListenerOutboundProxy
    implements ChannelOutboundHandler {
        protected ListenerOutboundProxy() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            assert (RakNetChildChannel.this.listener.eventLoop().inEventLoop());
        }

        public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
            promise.setFailure((Throwable)new UnsupportedOperationException());
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            promise.setFailure((Throwable)new UnsupportedOperationException());
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
            promise.setFailure((Throwable)new UnsupportedOperationException());
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
            if (RakNetChildChannel.this.listener.isRegistered()) {
                ChannelPromise listenerClose = ctx.newPromise();
                RakNetChildChannel.this.listener.close(RakNetChildChannel.this.wrapPromise(listenerClose));
                listenerClose.addListener(future -> {
                    if (!future.isSuccess()) {
                        future.cause().printStackTrace();
                    }
                    ctx.close(promise);
                });
            } else {
                ctx.close(promise);
            }
        }

        public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
            ctx.deregister(promise);
        }

        public void read(ChannelHandlerContext ctx) {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            RakNetChildChannel.this.listener.write(msg, RakNetChildChannel.this.wrapPromise(promise)).addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
        }

        public void flush(ChannelHandlerContext ctx) {
            RakNetChildChannel.this.listener.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (cause instanceof NoRouteToHostException) {
                return;
            }
            ctx.fireExceptionCaught(cause);
        }
    }

    protected class ReadHandler
    extends ChannelInboundHandlerAdapter {
        protected ReadHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            RakNetChildChannel.this.registerApplicationChannelIfNecessary();
            RakNetChildChannel.this.initStandaloneListener().addListener(future -> {
                if (RakNetChildChannel.this.applicationChannel.isRegistered()) {
                    this.channelActive0();
                } else {
                    RakNetChildChannel.this.pendingApplicationChannelOperations.add(this::channelActive0);
                }
            });
        }

        private void channelActive0() {
            RakNetChildChannel.this.applicationChannel.eventLoop().execute(() -> {
                RakNetChildChannel.this.applicationChannel.setActiveInternal(true);
                RakNetChildChannel.this.applicationChannel.pipeline().fireChannelActive();
            });
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            RakNetChildChannel.this.registerApplicationChannelIfNecessary();
            if (RakNetChildChannel.this.applicationChannel.isRegistered()) {
                this.channelInactive0();
            } else {
                RakNetChildChannel.this.pendingApplicationChannelOperations.add(this::channelInactive0);
            }
        }

        private void channelInactive0() {
            RakNetChildChannel.this.applicationChannel.eventLoop().execute(() -> {
                RakNetChildChannel.this.applicationChannel.setActiveInternal(false);
                RakNetChildChannel.this.applicationChannel.pipeline().fireChannelInactive();
            });
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            RakNetChildChannel.this.registerApplicationChannelIfNecessary();
            if (RakNetChildChannel.this.applicationChannel.isRegistered()) {
                RakNetChildChannel.this.applicationChannel.pipeline().fireChannelRead(msg);
            } else {
                RakNetChildChannel.this.pendingApplicationChannelOperations.add(() -> RakNetChildChannel.this.applicationChannel.pipeline().fireChannelRead(msg));
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            if (!RakNetChildChannel.this.applicationChannel.isRegistered()) {
                return;
            }
            RakNetChildChannel.this.applicationChannel.pipeline().fireChannelReadComplete();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (RakNetChildChannel.this.applicationChannel.isRegistered()) {
                RakNetChildChannel.this.registerApplicationChannelIfNecessary();
            }
            if (evt == FlushTickHandler.FLUSH_CHECK_SIGNAL || evt instanceof FlushTickHandler.MissedFlushes) {
                return;
            }
            RakNetChildChannel.this.registerApplicationChannelIfNecessary();
            if (RakNetChildChannel.this.applicationChannel.isRegistered()) {
                RakNetChildChannel.this.applicationChannel.pipeline().fireUserEventTriggered(evt);
            } else {
                RakNetChildChannel.this.pendingApplicationChannelOperations.add(() -> RakNetChildChannel.this.applicationChannel.pipeline().fireUserEventTriggered(evt));
            }
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            RakNetChildChannel.this.registerApplicationChannelIfNecessary();
            if (RakNetChildChannel.this.applicationChannel.isRegistered()) {
                RakNetChildChannel.this.applicationChannel.pipeline().fireChannelWritabilityChanged();
            } else {
                RakNetChildChannel.this.pendingApplicationChannelOperations.add(() -> RakNetChildChannel.this.applicationChannel.pipeline().fireChannelWritabilityChanged());
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            RakNetChildChannel.this.registerApplicationChannelIfNecessary();
            if (RakNetChildChannel.this.applicationChannel.isRegistered()) {
                RakNetChildChannel.this.applicationChannel.pipeline().fireExceptionCaught(cause);
            } else {
                RakNetChildChannel.this.pendingApplicationChannelOperations.add(() -> RakNetChildChannel.this.applicationChannel.pipeline().fireExceptionCaught(cause));
            }
        }
    }
}

