/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.server.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.packet.ConnectionRequest1;
import network.ycc.raknet.packet.InvalidVersion;
import network.ycc.raknet.packet.Packet;
import network.ycc.raknet.server.pipeline.UdpPacketHandler;

public class ConnectionListener
extends UdpPacketHandler<ConnectionRequest1> {
    public static final String NAME = "rn-connect-init";

    public ConnectionListener() {
        super(ConnectionRequest1.class);
    }

    @Override
    protected void handle(ChannelHandlerContext ctx, InetSocketAddress sender, InetSocketAddress recipient, ConnectionRequest1 request) {
        RakNet.Config config = RakNet.config(ctx);
        if (config.containsProtocolVersion(request.getProtocolVersion())) {
            ReferenceCountUtil.retain((Object)request);
            ctx.channel().connect((SocketAddress)sender, (SocketAddress)recipient).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE, future -> {
                if (future.isSuccess()) {
                    this.resendRequest(ctx, sender, request);
                } else {
                    ReferenceCountUtil.safeRelease((Object)request);
                }
            }});
        } else {
            this.sendResponse(ctx, sender, new InvalidVersion(config.getMagic(), config.getServerId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(ChannelHandlerContext ctx, InetSocketAddress sender, Packet packet) {
        RakNet.Config config = RakNet.config(ctx);
        ByteBuf buf = ctx.alloc().ioBuffer(packet.sizeHint());
        try {
            config.getCodec().encode(packet, buf);
            ctx.writeAndFlush((Object)new DatagramPacket(buf.retain(), sender)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)packet);
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resendRequest(ChannelHandlerContext ctx, InetSocketAddress sender, ConnectionRequest1 request) {
        RakNet.Config config = RakNet.config(ctx);
        ByteBuf buf = ctx.alloc().ioBuffer(request.sizeHint());
        try {
            config.getCodec().encode(request, buf);
            ctx.pipeline().fireChannelRead((Object)new DatagramPacket(buf.retain(), null, sender)).fireChannelReadComplete();
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)request);
            buf.release();
        }
    }
}

