/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.velocity.connection;

import com.google.common.base.Preconditions;
import com.ishland.raknetify.common.connection.MultiChannelingStreamingCompression;
import com.ishland.raknetify.common.connection.MultiChannellingEncryption;
import com.ishland.raknetify.common.connection.RakNetSimpleMultiChannelCodec;
import com.ishland.raknetify.common.connection.SynchronizationLayer;
import com.ishland.raknetify.velocity.RaknetifyVelocityPlugin;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.crypto.EncryptionUtils;
import com.velocitypowered.proxy.protocol.VelocityConnectionEvent;
import com.velocitypowered.proxy.protocol.packet.AvailableCommandsPacket;
import com.velocitypowered.proxy.protocol.packet.EncryptionResponsePacket;
import com.velocitypowered.proxy.protocol.packet.JoinGamePacket;
import com.velocitypowered.proxy.protocol.packet.RespawnPacket;
import com.velocitypowered.proxy.protocol.packet.SetCompressionPacket;
import com.velocitypowered.proxy.protocol.packet.config.FinishedUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.config.StartUpdatePacket;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.security.KeyPair;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class RakNetVelocityChannelEventListener
extends ChannelDuplexHandler {
    public static final String NAME = "raknetify-velocity-event-listener";
    private SecretKey encryptionKey = null;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof SetCompressionPacket) {
            MultiChannelingStreamingCompression compression = (MultiChannelingStreamingCompression)ctx.channel().pipeline().get(MultiChannelingStreamingCompression.class);
            if (compression != null && compression.isActive()) {
                RaknetifyVelocityPlugin.LOGGER.info("Preventing vanilla compression as streaming compression is enabled");
                promise.setSuccess();
                return;
            }
        } else {
            if (msg instanceof RespawnPacket || msg instanceof JoinGamePacket || msg instanceof StartUpdatePacket || msg instanceof FinishedUpdatePacket) {
                ctx.write(SynchronizationLayer.SYNC_REQUEST_OBJECT);
                super.write(ctx, msg, promise);
                return;
            }
            if (msg instanceof AvailableCommandsPacket) {
                ctx.write(RakNetSimpleMultiChannelCodec.SIGNAL_START_MULTICHANNEL);
                super.write(ctx, msg, promise);
                return;
            }
        }
        super.write(ctx, msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof EncryptionResponsePacket) {
            EncryptionResponsePacket packet = (EncryptionResponsePacket)msg;
            try {
                byte[] secret = EncryptionUtils.decryptRsa((KeyPair)((VelocityServer)RaknetifyVelocityPlugin.PROXY).getServerKeyPair(), (byte[])packet.getSharedSecret());
                this.encryptionKey = new SecretKeySpec(secret, "AES");
            }
            catch (Throwable t) {
                RaknetifyVelocityPlugin.LOGGER.warn("Failed to decrypt captured encryption secret, the raknetify connection is broken", t);
            }
        }
        super.channelRead(ctx, msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        if (evt == VelocityConnectionEvent.COMPRESSION_ENABLED) {
            MultiChannelingStreamingCompression compression = (MultiChannelingStreamingCompression)ctx.channel().pipeline().get(MultiChannelingStreamingCompression.class);
            if (compression != null && compression.isActive()) {
                RaknetifyVelocityPlugin.LOGGER.info("Preventing vanilla compression as streaming compression is enabled");
                ctx.channel().pipeline().replace("compression-encoder", "compression-encoder", (ChannelHandler)new ChannelDuplexHandler());
                ctx.channel().pipeline().replace("compression-decoder", "compression-decoder", (ChannelHandler)new ChannelDuplexHandler());
                MinecraftConnection minecraftConnection = (MinecraftConnection)ctx.channel().pipeline().get(MinecraftConnection.class);
                if (minecraftConnection != null) {
                    minecraftConnection.setCompressionThreshold(-1);
                } else {
                    RaknetifyVelocityPlugin.LOGGER.warn("Unable to sync compression state with velocity");
                }
            }
        } else if (evt == VelocityConnectionEvent.COMPRESSION_DISABLED) {
            ctx.channel().pipeline().replace("frame-decoder", "frame-decoder", (ChannelHandler)new ChannelDuplexHandler());
            ctx.channel().pipeline().replace("frame-encoder", "frame-encoder", (ChannelHandler)new ChannelDuplexHandler());
        } else if (evt == VelocityConnectionEvent.ENCRYPTION_ENABLED) {
            Preconditions.checkState((this.encryptionKey != null ? 1 : 0) != 0, (Object)"EncryptionResponse not received yet or already consumed");
            ctx.channel().pipeline().replace("cipher-encoder", "cipher-encoder", (ChannelHandler)new ChannelDuplexHandler());
            ctx.channel().pipeline().replace("cipher-decoder", "cipher-decoder", (ChannelHandler)new ChannelDuplexHandler());
            ctx.channel().pipeline().addBefore("raknetify-multichannel-streaming-compression", "raknetify-multichannel-encryption", (ChannelHandler)new MultiChannellingEncryption(this.encryptionKey));
        }
    }
}

