/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.velocity.connection;

import com.ishland.raknetify.common.Constants;
import com.ishland.raknetify.common.connection.ByteBufCopyDecoder;
import com.ishland.raknetify.common.connection.RakNetConnectionUtil;
import com.ishland.raknetify.common.connection.RakNetSimpleMultiChannelCodec;
import com.ishland.raknetify.common.connection.multichannel.CustomPayloadChannel;
import com.ishland.raknetify.common.data.ProtocolMultiChannelMappings;
import com.ishland.raknetify.velocity.RaknetifyVelocityPlugin;
import com.ishland.raknetify.velocity.connection.RakNetVelocityChannelEventListener;
import com.ishland.raknetify.velocity.connection.RakNetVelocityPingUpdater;
import com.ishland.raknetify.velocity.connection.RakNetVelocityServerChannelEventListener;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import java.util.Arrays;
import network.ycc.raknet.RakNet;

public class RakNetVelocityConnectionUtil {
    private RakNetVelocityConnectionUtil() {
    }

    public static void initChannel(Channel channel) {
        if (channel.config() instanceof RakNet.Config) {
            RakNetConnectionUtil.initChannel(channel);
            channel.pipeline().addAfter("raknetify-multichannel-streaming-compression", "raknetify-simple-multi-channel-data-codec", (ChannelHandler)new RakNetSimpleMultiChannelCodec(253));
            channel.pipeline().addAfter("raknetify-simple-multi-channel-data-codec", "raknetify-byte-buf-copy-decoder", (ChannelHandler)new ByteBufCopyDecoder());
        }
    }

    public static void postInitChannel(Channel channel, boolean isClientSide) {
        if (channel.config() instanceof RakNet.Config) {
            channel.pipeline().replace("read-timeout", "read-timeout", (ChannelHandler)new ChannelDuplexHandler());
            channel.pipeline().replace("frame-decoder", "frame-decoder", (ChannelHandler)new ChannelDuplexHandler());
            channel.pipeline().replace("frame-encoder", "frame-encoder", (ChannelHandler)new ChannelDuplexHandler());
            if (channel.pipeline().get(HAProxyMessageDecoder.class) != null) {
                channel.pipeline().remove(HAProxyMessageDecoder.class);
            }
            channel.pipeline().addBefore("handler", "raknetify-velocity-event-listener", (ChannelHandler)new RakNetVelocityChannelEventListener());
        }
    }

    public static void onPlayerLogin(LoginEvent evt) {
        ChannelConfig channelConfig;
        ConnectedPlayer player = (ConnectedPlayer)evt.getPlayer();
        Channel channel = player.getConnection().getChannel();
        if (channel != null && (channelConfig = channel.config()) instanceof RakNet.Config) {
            RakNet.Config config = (RakNet.Config)channelConfig;
            RakNetSimpleMultiChannelCodec multiChannelCodec = (RakNetSimpleMultiChannelCodec)channel.pipeline().get(RakNetSimpleMultiChannelCodec.class);
            if (multiChannelCodec != null) {
                ProtocolVersion protocolVersion = player.getProtocolVersion();
                ProtocolMultiChannelMappings.VersionMapping versionMapping = ProtocolMultiChannelMappings.INSTANCE.mappings.get(protocolVersion.getProtocol());
                if (versionMapping != null) {
                    int pluginMessageId = StateRegistry.PLAY.getProtocolRegistry(ProtocolUtils.Direction.CLIENTBOUND, protocolVersion).getPacketId((MinecraftPacket)new PluginMessagePacket());
                    if (Constants.DEBUG) {
                        RaknetifyVelocityPlugin.LOGGER.info("PluginMessage packetId=%d at version=%d".formatted(pluginMessageId, protocolVersion.getProtocol()));
                    }
                    multiChannelCodec.addHandler(new CustomPayloadChannel.OverrideHandler(value -> value == pluginMessageId));
                    multiChannelCodec.addHandler(new RakNetSimpleMultiChannelCodec.PacketIdBasedOverrideHandler(versionMapping.s2c, "%s (%d)".formatted(protocolVersion.getVersionIntroducedIn(), protocolVersion.getProtocol())));
                } else {
                    RaknetifyVelocityPlugin.LOGGER.warn("No multi-channel mappings for protocol version {} ({})", (Object)protocolVersion.getProtocol(), (Object)Arrays.toString(protocolVersion.getVersionsSupportedBy().toArray(String[]::new)));
                }
            }
            channel.pipeline().addBefore("handler", "raknetify-velocity-ping-updater", (ChannelHandler)new RakNetVelocityPingUpdater(player));
            RaknetifyVelocityPlugin.LOGGER.info(String.format("Raknetify: %s logged in via RakNet, mtu %d", evt.getPlayer().getGameProfile().getName(), config.getMTU()));
        }
    }

    public static void onServerSwitch(ServerPostConnectEvent evt) {
        ConnectedPlayer player = (ConnectedPlayer)evt.getPlayer();
        VelocityServerConnection connectedServer = player.getConnectedServer();
        if (connectedServer == null) {
            RaknetifyVelocityPlugin.LOGGER.warn("No connected server for player ({}) after server switch?", (Object)player);
            return;
        }
        MinecraftConnection serverConnection = connectedServer.getConnection();
        if (serverConnection == null) {
            RaknetifyVelocityPlugin.LOGGER.warn("Connected server ({}) have no underlying connection?", (Object)connectedServer);
            return;
        }
        Channel channel = player.getConnection().getChannel();
        if (channel.config() instanceof RakNet.Config) {
            serverConnection.getChannel().pipeline().addBefore("handler", "raknetify-bungee-downstream-event-listener", (ChannelHandler)new RakNetVelocityServerChannelEventListener(channel));
        }
    }
}

