/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.velocity.init;

import com.google.common.base.Preconditions;
import com.ishland.raknetify.common.util.NetworkInterfaceListener;
import com.ishland.raknetify.common.util.ReflectionUtil;
import com.ishland.raknetify.velocity.RaknetifyVelocityPlugin;
import com.ishland.raknetify.velocity.connection.RakNetVelocityConnectionUtil;
import com.velocitypowered.api.event.proxy.ListenerBoundEvent;
import com.velocitypowered.api.event.proxy.ListenerCloseEvent;
import com.velocitypowered.api.network.ListenerType;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.network.ConnectionManager;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.DatagramChannel;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import network.ycc.raknet.server.channel.RakNetServerChannel;

public class VelocityRaknetifyServer {
    private static final int portOverride = Integer.getInteger("raknetify.velocity.portOverride", -1);
    private static final Method INIT_CHANNEL;
    private static final ReferenceOpenHashSet<ChannelFuture> channels;
    private static volatile InetSocketAddress currentServerAddress;
    private static volatile boolean active;

    public static void start(ListenerBoundEvent evt) {
        InetSocketAddress address;
        if (evt.getListenerType() != ListenerType.MINECRAFT) {
            return;
        }
        Preconditions.checkArgument((boolean)(RaknetifyVelocityPlugin.PROXY instanceof VelocityServer));
        Preconditions.checkState((boolean)channels.isEmpty(), (Object)"Raknetify Server is already running");
        currentServerAddress = address = evt.getAddress();
        active = true;
        if (address.getAddress().isAnyLocalAddress()) {
            try {
                for (NetworkInterface networkInterface : NetworkInterface.networkInterfaces().toList()) {
                    for (InetAddress inetAddress : networkInterface.inetAddresses().toList()) {
                        try {
                            VelocityRaknetifyServer.startServer(new InetSocketAddress(inetAddress, address.getPort()));
                        }
                        catch (Throwable t) {
                            RaknetifyVelocityPlugin.LOGGER.error("Failed to start raknetify server", t);
                        }
                    }
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to start raknetify server", t);
            }
        } else {
            VelocityRaknetifyServer.startServer(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startServer(InetSocketAddress address) {
        try {
            final ConnectionManager cm = (ConnectionManager)ReflectionUtil.accessible(VelocityServer.class.getDeclaredField("cm")).get(RaknetifyVelocityPlugin.PROXY);
            Object transportType = ReflectionUtil.accessible(ConnectionManager.class.getDeclaredField("transportType")).get(cm);
            ChannelFactory datagramChannelFactory = (ChannelFactory)ReflectionUtil.accessible(Class.forName("com.velocitypowered.proxy.network.TransportType").getDeclaredField("datagramChannelFactory")).get(transportType);
            EventLoopGroup bossGroup = (EventLoopGroup)ReflectionUtil.accessible(ConnectionManager.class.getDeclaredField("bossGroup")).get(cm);
            EventLoopGroup workerGroup = (EventLoopGroup)ReflectionUtil.accessible(ConnectionManager.class.getDeclaredField("workerGroup")).get(cm);
            boolean hasPortOverride = portOverride > 0 && portOverride < 65535;
            InetSocketAddress actualAddress = hasPortOverride ? new InetSocketAddress(address.getAddress(), portOverride) : address;
            ReferenceOpenHashSet<ChannelFuture> referenceOpenHashSet = channels;
            synchronized (referenceOpenHashSet) {
                for (ChannelFuture future : channels) {
                    if (!future.channel().localAddress().equals(actualAddress)) continue;
                    return;
                }
                ChannelFuture future = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channelFactory(() -> new RakNetServerChannel(() -> {
                    DatagramChannel channel = (DatagramChannel)datagramChannelFactory.newChannel();
                    channel.config().setOption(ChannelOption.IP_TOS, (Object)24);
                    channel.config().setRecvByteBufAllocator((RecvByteBufAllocator)new FixedRecvByteBufAllocator(8704).maxMessagesPerRead(128));
                    return channel;
                }))).group(bossGroup, workerGroup).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel channel) throws Exception {
                        RakNetVelocityConnectionUtil.initChannel(channel);
                        INIT_CHANNEL.invoke((Object)cm.serverChannelInitializer.get(), channel);
                        RakNetVelocityConnectionUtil.postInitChannel(channel, false);
                    }
                }).localAddress((SocketAddress)actualAddress)).bind().syncUninterruptibly();
                RaknetifyVelocityPlugin.LOGGER.info("Raknetify server started on {}", (Object)future.channel().localAddress());
                channels.add(future);
            }
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                RaknetifyVelocityPlugin.LOGGER.error("Raknetify server failed to start on {}: {}", (Object)address, (Object)t.getMessage());
                return;
            }
            throw new RuntimeException("Failed to start Raknetify server", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(ListenerCloseEvent evt) {
        if (evt.getListenerType() != ListenerType.MINECRAFT) {
            return;
        }
        Preconditions.checkArgument((boolean)(RaknetifyVelocityPlugin.PROXY instanceof VelocityServer));
        Preconditions.checkState((!channels.isEmpty() ? 1 : 0) != 0, (Object)"Raknetify Server is not running");
        ReferenceOpenHashSet<ChannelFuture> referenceOpenHashSet = channels;
        synchronized (referenceOpenHashSet) {
            active = false;
            for (ChannelFuture channel : channels) {
                VelocityRaknetifyServer.closeServer(channel);
            }
            channels.clear();
        }
    }

    private static void closeServer(ChannelFuture channel) {
        RaknetifyVelocityPlugin.LOGGER.info("Closing Raknetify server {}", (Object)channel.channel().localAddress());
        try {
            channel.channel().close().sync();
        }
        catch (InterruptedException e) {
            RaknetifyVelocityPlugin.LOGGER.error("Interrupted whilst closing raknetify server");
        }
    }

    static {
        try {
            INIT_CHANNEL = ReflectionUtil.accessible(ChannelInitializer.class.getDeclaredMethod("initChannel", Channel.class));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        channels = new ReferenceOpenHashSet();
        currentServerAddress = null;
        active = false;
        NetworkInterfaceListener.addListener(event -> RaknetifyVelocityPlugin.PROXY.getScheduler().buildTask((Object)RaknetifyVelocityPlugin.INSTANCE, () -> {
            if (!active) {
                return;
            }
            InetSocketAddress address = currentServerAddress;
            if (address != null && address.getAddress().isAnyLocalAddress()) {
                if (event.added()) {
                    VelocityRaknetifyServer.startServer(new InetSocketAddress(event.address(), address.getPort()));
                } else {
                    ReferenceOpenHashSet<ChannelFuture> referenceOpenHashSet = channels;
                    synchronized (referenceOpenHashSet) {
                        Iterator iterator = channels.iterator();
                        while (iterator.hasNext()) {
                            ChannelFuture future = (ChannelFuture)iterator.next();
                            if (!((InetSocketAddress)future.channel().localAddress()).getAddress().equals(event.address())) continue;
                            VelocityRaknetifyServer.closeServer(future);
                            iterator.remove();
                        }
                    }
                }
            }
        }).delay(100L, TimeUnit.MILLISECONDS).schedule());
    }
}

