/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.config;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import network.ycc.raknet.RakNet;

public class DefaultMagic
implements RakNet.Magic {
    protected final byte[] magicData;

    public DefaultMagic(byte[] magicData) {
        this.magicData = magicData;
    }

    public static DefaultMagic decode(ByteBuf buf) {
        byte[] magicData = new byte[16];
        buf.readBytes(magicData);
        return new DefaultMagic(magicData);
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeBytes(this.magicData);
    }

    @Override
    public void read(ByteBuf buf) {
        for (byte b : this.magicData) {
            if (buf.readByte() == b) continue;
            throw new RakNet.Magic.MagicMismatchException();
        }
    }

    @Override
    public void verify(RakNet.Magic other) {
        ByteBuf tmp = Unpooled.buffer((int)16);
        this.write(tmp);
        other.read(tmp);
    }
}

